/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.auth;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.auth.UserInfoUtil;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.certificate.cmd.CheckCertificateCmd;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.session.SessionTicketidRecorder;
import com.bokesoft.yes.tools.json.JSONUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.mid.auth.Login;
import com.bokesoft.yigo.mid.base.CertificateException;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.LoginInfo;
import com.bokesoft.yigo.mid.para.SysPara;
import com.bokesoft.yigo.mid.rsa.RSAClientUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import org.json.JSONObject;

public class LoginCheckCmd
extends DefaultServiceCmd {
    private String user = null;
    private String password = null;
    private int mode = 1;
    private long role = -1L;
    private long clusterID = -1L;
    private Map<String, Object> paras = null;
    private String tmpClientID = "";
    private String validateCode = null;
    private String clientSignedStr = null;
    private int ticketID = 0;

    public LoginCheckCmd() {
    }

    public LoginCheckCmd(String string, String string2, int n2, long l2, long l3, String string3, String string4, String string5, int n3, Map<String, Object> map) {
        this.user = string;
        this.password = string2;
        this.mode = n2;
        this.role = l2;
        this.clusterID = l3;
        this.paras = map;
        this.tmpClientID = string3;
        this.validateCode = string4;
        this.clientSignedStr = string5;
        this.ticketID = n3;
    }

    public void dealArguments(DefaultContext object, StringHashMap<Object> stringHashMap) throws Throwable {
        object = (String)stringHashMap.get((Object)"logininfo");
        if (stringHashMap.containsKey((Object)"tmpclientid")) {
            this.tmpClientID = (String)stringHashMap.get((Object)"tmpclientid");
        }
        if (stringHashMap.containsKey((Object)"signedstr")) {
            this.clientSignedStr = TypeConvertor.toString((Object)stringHashMap.get((Object)"signedstr"));
        }
        object = RSAClientUtil.decryptByPrivate((String)SysPara.getInstance().get("PrivateKey"), (String)object);
        object = new JSONObject((String)object);
        this.user = object.getString("user");
        this.password = object.getString("password");
        if (object.has("mode")) {
            this.mode = object.getInt("mode");
        }
        if (object.has("role")) {
            this.role = object.getLong("role");
        }
        if (object.has("clusterID")) {
            this.clusterID = object.getLong("clusterID");
        }
        if (object.has("ticketid")) {
            this.ticketID = object.getInt("ticketid");
        }
        if (object.has("validatecode")) {
            this.validateCode = object.getString("validatecode");
        }
        if ((object = (String)stringHashMap.get((Object)"paras")) != null && !((String)object).isEmpty()) {
            this.paras = JSONUtil.toMap((String)object);
        }
    }

    public String getCmd() {
        return "LoginCheck";
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        long l2;
        Object object;
        Object object22;
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        String string = defaultContext.getEnv().getLocale();
        String string2 = iMetaFactory.getSolutionPath();
        for (Object object22 : iMetaFactory.getProjectKeys()) {
            object = iMetaFactory.getMetaProject((String)object22);
            MetaStringTable metaStringTable = object.getStrings();
            if (metaStringTable.containsLang(string) || !new File((String)(object22 = string2 + File.separator + (String)object22 + File.separator + "i18n" + File.separator + "strings-" + string + ".xml")).exists()) continue;
            object22 = Files.newInputStream(Paths.get((String)object22, new String[0]), new OpenOption[0]);
            metaStringTable.load(string, (InputStream)object22);
            object.setStrings(metaStringTable);
        }
        MetaStringTable metaStringTable = iMetaFactory.getStrings(string);
        if (!metaStringTable.containsLang(string) && new File((String)(object22 = string2 + File.separator + "i18n" + File.separator + "strings-" + string + ".xml")).exists()) {
            object = Files.newInputStream(Paths.get((String)object22, new String[0]), new OpenOption[0]);
            metaStringTable.load(string, (InputStream)object);
            iMetaFactory.setStrings(metaStringTable);
        }
        if ((object22 = ServerSetting.getInstance()).containsValidateLevel(6) && SessionTicketidRecorder.getTicketID((String)this.tmpClientID) != this.ticketID) {
            throw new CertificateException(8, "Error connect!");
        }
        if ((object22.containsValidateLevel(3) || object22.containsValidateLevel(4)) && (object = UserInfoUtil.getUserInfo(defaultContext, this.user)) != null && !TypeConvertor.toBoolean((Object)new CheckCertificateCmd(l2 = object.getLong("userid"), this.mode, this.clientSignedStr).doCmd(defaultContext)).booleanValue()) {
            throw new CertificateException(1, "Certificate not found or expired!");
        }
        defaultContext.getVE().setAuthenticate(true);
        return new Login(new LoginInfo(this.user, this.password, this.role, this.mode, this.tmpClientID, this.validateCode, this.paras)).doLoginCheck(defaultContext);
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new LoginCheckCmd();
    }
}

