/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.report.print.chart.util;

import com.bokesoft.yes.report.output.OutputEmbedChart;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.report.print.chart.IReportTableModel;
import com.bokesoft.yigo.report.print.chart.OutputChartSeries;
import com.bokesoft.yigo.report.print.chart.data.ReportCategoryData;
import com.bokesoft.yigo.report.print.chart.data.ReportChartDataModel;
import com.bokesoft.yigo.report.print.chart.data.ReportSeriesData;
import java.awt.Font;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ReportChartDataUtils {
    public static final Font DEFAULT_AXIS_LABEL_FONT = new Font("\u5b8b\u4f53", 0, 12);
    public static final Font DEFAULT_TICK_LABEL_FONT = new Font("\u5b8b\u4f53", 0, 10);

    public static void setDefaultFont(JFreeChart jFreeChart) {
        jFreeChart.getTitle().setFont(new Font("\u5b8b\u4f53", 1, 12));
        if (jFreeChart.getPlot() instanceof XYPlot) {
            jFreeChart.getXYPlot().getDomainAxis().setLabelFont(DEFAULT_AXIS_LABEL_FONT);
            jFreeChart.getXYPlot().getDomainAxis().setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
            jFreeChart.getXYPlot().getRangeAxis().setLabelFont(DEFAULT_AXIS_LABEL_FONT);
            jFreeChart.getXYPlot().getRangeAxis().setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
        } else if (jFreeChart.getPlot() instanceof CategoryPlot) {
            jFreeChart.getCategoryPlot().getDomainAxis().setLabelFont(DEFAULT_AXIS_LABEL_FONT);
            jFreeChart.getCategoryPlot().getDomainAxis().setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
            jFreeChart.getCategoryPlot().getRangeAxis().setLabelFont(DEFAULT_AXIS_LABEL_FONT);
            jFreeChart.getCategoryPlot().getRangeAxis().setTickLabelFont(DEFAULT_TICK_LABEL_FONT);
        } else if (jFreeChart.getPlot() instanceof PiePlot) {
            ((PiePlot)jFreeChart.getPlot()).setLabelFont(DEFAULT_AXIS_LABEL_FONT);
        }
        jFreeChart.getLegend().setItemFont(DEFAULT_TICK_LABEL_FONT);
    }

    public static DefaultCategoryDataset getCategoryDataset(OutputEmbedChart outputEmbedChart) {
        IReportTableModel iReportTableModel = outputEmbedChart.getReportTableModel();
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        if (iReportTableModel != null) {
            String string = outputEmbedChart.getCategorySource();
            for (int i = 0; i < iReportTableModel.getCount(); ++i) {
                Iterator<OutputChartSeries> iterator = outputEmbedChart.iteratorSeries();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    try {
                        String string2 = TypeConvertor.toString((Object)iReportTableModel.getValueByMulti(i, string));
                        String string3 = TypeConvertor.toString((Object)iReportTableModel.getValueByMulti(i, ((OutputChartSeries)object).getSource()));
                        object = TypeConvertor.toBigDecimal((Object)iReportTableModel.getFieldValue(i, ((OutputChartSeries)object).getDataKey()));
                        if (outputEmbedChart.getSeriesInRow()) {
                            defaultCategoryDataset.addValue((Number)object, (Comparable)((Object)string3), (Comparable)((Object)string2));
                            continue;
                        }
                        defaultCategoryDataset.addValue((Number)object, (Comparable)((Object)string2), (Comparable)((Object)string3));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        return defaultCategoryDataset;
    }

    public static DefaultCategoryDataset getCategoryDatasetDemo() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"Series-1"), (Comparable)((Object)"Category-1"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Series-2"), (Comparable)((Object)"Category-1"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"Series-3"), (Comparable)((Object)"Category-1"));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)"Series-1"), (Comparable)((Object)"Category-2"));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)"Series-2"), (Comparable)((Object)"Category-2"));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)"Series-3"), (Comparable)((Object)"Category-2"));
        ReportChartDataUtils.setDefaultFont(ChartFactory.createBarChart((String)"Title(\u56fe\u8868\u6807\u9898)", (String)"CategoryAxisTitle(\u9879\u76ee\u8f74\u6807\u9898)", (String)"SeriesAxisTitle(\u7cfb\u5217\u8f74\u6807\u9898)", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false));
        return defaultCategoryDataset;
    }

    public static boolean isFormula(String string) {
        return Pattern.compile("[\\w]+[\\s]?\\(.*\\)", 2).matcher(string).find();
    }

    public static ReportChartDataModel buildChartDataModel(IReportTableModel iReportTableModel, OutputEmbedChart object) throws Throwable {
        String string;
        String string2 = ((OutputEmbedChart)object).getCategorySource();
        ReportChartDataModel reportChartDataModel = new ReportChartDataModel();
        ReportCategoryData reportCategoryData = new ReportCategoryData();
        for (int i = 0; i < iReportTableModel.getCount(); ++i) {
            string = TypeConvertor.toString((Object)iReportTableModel.getValueByMulti(i, "GetDictValue('Material', GetValue('" + string2 + "'), 'Name')"));
            if (reportCategoryData.contains(string)) continue;
            reportCategoryData.add(string);
        }
        reportChartDataModel.setCategory(reportCategoryData);
        Iterator<OutputChartSeries> iterator = ((OutputEmbedChart)object).iteratorSeries();
        while (iterator.hasNext()) {
            int n;
            OutputChartSeries outputChartSeries = iterator.next();
            string = outputChartSeries.getSource();
            if (string != null && !string.isEmpty()) {
                object = new HashMap();
                for (n = 0; n < iReportTableModel.getCount(); ++n) {
                    Object object2 = iReportTableModel.getFieldValue(n, string);
                    BigDecimal bigDecimal = TypeConvertor.toBigDecimal((Object)iReportTableModel.getFieldValue(n, outputChartSeries.getDataKey()));
                    ReportSeriesData reportSeriesData = (ReportSeriesData)((HashMap)object).get(object2);
                    if (reportSeriesData == null) {
                        reportSeriesData = new ReportSeriesData();
                        reportSeriesData.init(reportCategoryData.size());
                        reportSeriesData.setTitle(object2.toString());
                        ((HashMap)object).put(object2, reportSeriesData);
                        reportChartDataModel.addSeries(reportSeriesData);
                    }
                    object2 = iReportTableModel.getValueByMulti(n, "GetDictValue('Material', GetValue('" + string2 + "'), 'Name')");
                    int n2 = reportCategoryData.indexOf(object2);
                    reportSeriesData.set(n2, bigDecimal);
                }
                continue;
            }
            object = new ReportSeriesData();
            for (n = 0; n < iReportTableModel.getCount(); ++n) {
                BigDecimal bigDecimal = TypeConvertor.toBigDecimal((Object)iReportTableModel.getFieldValue(n, outputChartSeries.getDataKey()));
                ((ReportSeriesData)object).add(bigDecimal);
            }
            reportChartDataModel.addSeries((ReportSeriesData)object);
        }
        return reportChartDataModel;
    }
}

