/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print;

import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.print.PrintUnitTrans;
import com.bokesoft.yes.report.print.g2dexport.G2dReportExport;
import com.bokesoft.yes.report.print.g2dexport.G2dTransContext;
import com.bokesoft.yes.report.print.paper.IPrintPaper;
import com.bokesoft.yes.report.print.paper.PrintPaperWorker;
import com.bokesoft.yes.report.print.transform.ReportTransform;
import com.bokesoft.yigo.report.delegate.IResourceResolver;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.event.PrintJobListener;

public class PrintImpl
implements Printable {
    private IResourceResolver resourceResolver = null;
    private PrintUnitTrans unitTrans = null;
    private boolean fillEmptyPrint = false;
    private PrintPaperWorker printWorker = null;

    public PrintImpl(IResourceResolver iResourceResolver, OutputPageSet outputPageSet, boolean bl) {
        this.resourceResolver = iResourceResolver;
        this.printWorker = new PrintPaperWorker();
        this.printWorker.preparePapers(outputPageSet);
        this.unitTrans = new PrintUnitTrans();
        this.fillEmptyPrint = bl;
    }

    @Override
    public int print(Graphics object, PageFormat object2, int n) throws PrinterException {
        if (Thread.interrupted()) {
            throw new PrinterException("Current thread interrupted.");
        }
        if (n >= this.printWorker.getPaperCount()) {
            return 1;
        }
        object2 = this.printWorker.getPaper(n);
        object = (Graphics2D)object;
        object = new G2dTransContext(this.resourceResolver, (Graphics2D)object);
        ((G2dTransContext)object).setOnlyFillEmptyContent(this.fillEmptyPrint);
        G2dReportExport g2dReportExport = new G2dReportExport(new PrintUnitTrans());
        new ReportTransform<G2dTransContext>(g2dReportExport).export((G2dTransContext)object, (IPrintPaper)object2);
        return 0;
    }

    public void print(PrintService object) throws Throwable {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintService((PrintService)object);
        object = printerJob.defaultPage();
        Object object2 = ((PageFormat)object).getPaper();
        double d = this.unitTrans.transSize(this.printWorker.getPaperWidth());
        double d2 = this.unitTrans.transSize(this.printWorker.getPaperHeight());
        ((Paper)object2).setSize(d, d2);
        ((Paper)object2).setImageableArea(0.0, 0.0, d, d2);
        ((PageFormat)object).setPaper((Paper)object2);
        printerJob.setJobName(this.printWorker.getTitle());
        if (this.printWorker.getPaperOrientation() == 0) {
            ((PageFormat)object).setOrientation(1);
        } else {
            ((PageFormat)object).setOrientation(0);
        }
        object2 = new Book();
        int n = this.printWorker.getPaperCount();
        ((Book)object2).append(this, (PageFormat)object, n);
        printerJob.setPageable((Pageable)object2);
        try {
            printerJob.print();
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            throw object;
        }
    }

    public void printImpl(String string, boolean bl) throws Throwable {
        PrintService printService = null;
        if (string != null && !string.isEmpty()) {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < printServiceArray.length; ++i) {
                PrintService printService2 = printServiceArray[i];
                if (!string.equalsIgnoreCase(printService2.getName())) continue;
                printService = printServiceArray[i];
                break;
            }
        }
        if (printService == null && bl) {
            printService = PrintServiceLookup.lookupDefaultPrintService();
        }
        this.printImpl(printService);
    }

    public void printImpl2(PrintService object, MediaSizeName mediaSizeName, PrintJobListener printJobListener) throws Throwable {
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        object = object.createPrintJob();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        float f = this.unitTrans.transSize(this.printWorker.getPaperWidth());
        float f2 = this.unitTrans.transSize(this.printWorker.getPaperHeight());
        if (this.printWorker.getPaperOrientation() == 0) {
            hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        } else {
            hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        }
        hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        hashPrintRequestAttributeSet.add(mediaSizeName);
        float f3 = f / 72.0f;
        f = f2 / 72.0f;
        hashPrintRequestAttributeSet.add(new MediaPrintableArea(0.0f, 0.0f, f3, f, 25400));
        Object object2 = new HashDocAttributeSet();
        object2 = new SimpleDoc(this, sERVICE_FORMATTED, (DocAttributeSet)object2);
        object.addPrintJobListener(printJobListener);
        object.print((Doc)object2, hashPrintRequestAttributeSet);
    }

    public void printImpl(PrintService printService) throws Throwable {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        Object object = pageFormat.getPaper();
        double d = this.unitTrans.transSize(this.printWorker.getPaperWidth());
        double d2 = this.unitTrans.transSize(this.printWorker.getPaperHeight());
        ((Paper)object).setSize(d, d2);
        ((Paper)object).setImageableArea(0.0, 0.0, d, d2);
        pageFormat.setPaper((Paper)object);
        printerJob.setJobName(this.printWorker.getTitle());
        if (this.printWorker.getPaperOrientation() == 0) {
            pageFormat.setOrientation(1);
        } else {
            pageFormat.setOrientation(0);
        }
        object = new Book();
        int n = this.printWorker.getPaperCount();
        ((Book)object).append(this, pageFormat, n);
        printerJob.setPageable((Pageable)object);
        printerJob.setPrintService(printService);
        printerJob.print();
    }
}

