/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.output;

import com.bokesoft.yes.report.output.OutputColumn;
import com.bokesoft.yes.report.output.OutputRow;
import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class OutputSection
implements JSONSerializable {
    private ArrayList<OutputColumn> columnArray = new ArrayList();
    private ArrayList<OutputRow> rowArray = new ArrayList();
    private boolean isFlowTop = true;
    private OutputColumn lockColumn = null;
    private boolean forceClip = false;
    private int leftIndex = -1;
    private int topIndex = -1;
    private int rightIndex = -1;
    private int bottomIndex = -1;

    public void addColumn(OutputColumn outputColumn) {
        if (outputColumn.isLock()) {
            this.lockColumn = outputColumn;
        }
        this.columnArray.add(outputColumn);
    }

    public int getColumnCount() {
        return this.columnArray.size();
    }

    public OutputColumn getColumn(int n) {
        return this.columnArray.get(n);
    }

    public void addRow(OutputRow outputRow) {
        this.rowArray.add(outputRow);
    }

    public void addAllRow(List<OutputRow> list) {
        this.rowArray.addAll(list);
    }

    public int getRowCount() {
        return this.rowArray.size();
    }

    public OutputRow getRow(int n) {
        return this.rowArray.get(n);
    }

    public void setFlowTop(boolean bl) {
        this.isFlowTop = bl;
    }

    public boolean isFlowTop() {
        return this.isFlowTop;
    }

    public boolean hasLockColumn() {
        return this.lockColumn != null;
    }

    public List<OutputColumn> getLockedColumns() {
        if (!this.hasLockColumn()) {
            return null;
        }
        ArrayList<OutputColumn> arrayList = new ArrayList<OutputColumn>();
        for (OutputColumn outputColumn : this.columnArray) {
            arrayList.add(outputColumn);
            if (!outputColumn.isLock()) continue;
        }
        return arrayList;
    }

    public List<OutputColumn> getUnLockedColumns() {
        boolean bl = !this.hasLockColumn();
        ArrayList<OutputColumn> arrayList = new ArrayList<OutputColumn>();
        for (OutputColumn outputColumn : this.columnArray) {
            if (outputColumn.isLock()) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            arrayList.add(outputColumn);
        }
        return arrayList;
    }

    public int indexof(OutputColumn outputColumn) {
        return this.columnArray.indexOf(outputColumn);
    }

    public void setForceClip(boolean bl) {
        this.forceClip = bl;
    }

    public boolean isForceClip() {
        return this.forceClip;
    }

    public void setLeftIndex(int n) {
        this.leftIndex = n;
    }

    public int getLeftIndex() {
        return this.leftIndex;
    }

    public void setTopIndex(int n) {
        this.topIndex = n;
    }

    public int getTopIndex() {
        return this.topIndex;
    }

    public void setRightIndex(int n) {
        this.rightIndex = n;
    }

    public int getRightIndex() {
        return this.rightIndex;
    }

    public void setBottomIndex(int n) {
        this.bottomIndex = n;
    }

    public int getBottomIndex() {
        return this.bottomIndex;
    }

    public int getContentWidth() {
        int n = 0;
        int n2 = 0;
        int n3 = this.columnArray.size() - 1;
        if (this.forceClip) {
            n2 = Math.max(this.leftIndex, 0);
            n3 = Math.min(this.rightIndex, n3);
        }
        while (n2 <= n3) {
            OutputColumn outputColumn = this.columnArray.get(n2);
            n += outputColumn.getWidth();
            ++n2;
        }
        return n;
    }

    public int getContentHeight() {
        int n = 0;
        int n2 = 0;
        int n3 = this.rowArray.size() - 1;
        if (this.forceClip) {
            n2 = Math.max(this.topIndex, 0);
            n3 = Math.min(this.bottomIndex, n3);
        }
        while (n2 <= n3) {
            OutputRow outputRow = this.rowArray.get(n2);
            n += outputRow.getHeight();
            ++n2;
        }
        return n;
    }

    public OutputSection clone() {
        OutputSection outputSection = new OutputSection();
        if (this.columnArray != null) {
            for (OutputColumn object : this.columnArray) {
                outputSection.addColumn(object.clone());
            }
        }
        if (this.rowArray != null) {
            for (OutputRow outputRow : this.rowArray) {
                outputSection.addRow(outputRow.clone());
            }
        }
        outputSection.setFlowTop(this.isFlowTop);
        outputSection.setForceClip(this.forceClip);
        outputSection.setLeftIndex(this.leftIndex);
        outputSection.setTopIndex(this.topIndex);
        outputSection.setRightIndex(this.rightIndex);
        outputSection.setBottomIndex(this.bottomIndex);
        return outputSection;
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject jSONObject;
        Iterator<Object> iterator;
        JSONArray jSONArray;
        JSONObject jSONObject2 = new JSONObject();
        if (this.columnArray != null) {
            jSONArray = new JSONArray();
            iterator = this.columnArray.iterator();
            while (iterator.hasNext()) {
                jSONObject = ((OutputColumn)iterator.next()).toJSON();
                jSONArray.put((Object)jSONObject);
            }
            jSONObject2.put("columns", (Object)jSONArray);
        }
        if (this.rowArray != null) {
            jSONArray = new JSONArray();
            iterator = this.rowArray.iterator();
            while (iterator.hasNext()) {
                jSONObject = ((OutputRow)iterator.next()).toJSON();
                jSONArray.put((Object)jSONObject);
            }
            jSONObject2.put("rows", (Object)jSONArray);
        }
        jSONObject2.put("isFlowTop", this.isFlowTop);
        jSONObject2.put("forceClip", this.forceClip);
        jSONObject2.put("leftIndex", this.leftIndex);
        jSONObject2.put("topIndex", this.topIndex);
        jSONObject2.put("rightIndex", this.rightIndex);
        jSONObject2.put("bottomIndex", this.bottomIndex);
        return jSONObject2;
    }

    public void fromJSON(JSONObject jSONObject) throws Throwable {
        Object object;
        JSONObject jSONObject2;
        int n;
        int n2;
        JSONArray jSONArray = jSONObject.optJSONArray("columns");
        if (jSONArray != null) {
            n2 = jSONArray.length();
            for (n = 0; n < n2; ++n) {
                jSONObject2 = jSONArray.getJSONObject(n);
                object = new OutputColumn();
                object.fromJSON(jSONObject2);
                this.columnArray.add((OutputColumn)object);
            }
        }
        if ((jSONArray = jSONObject.optJSONArray("rows")) != null) {
            n2 = jSONArray.length();
            for (n = 0; n < n2; ++n) {
                jSONObject2 = jSONArray.getJSONObject(n);
                object = new OutputRow();
                ((OutputRow)object).fromJSON(jSONObject2);
                this.rowArray.add((OutputRow)object);
            }
        }
        this.isFlowTop = jSONObject.optBoolean("isFlowTop");
        this.forceClip = jSONObject.optBoolean("forceClip");
        this.leftIndex = jSONObject.optInt("leftIndex");
        this.topIndex = jSONObject.optInt("topIndex");
        this.rightIndex = jSONObject.optInt("rightIndex");
        this.bottomIndex = jSONObject.optInt("bottomIndex");
    }
}

