/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.parser;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.parser.EvalScope;
import com.bokesoft.yes.parser.IEvalEnv;
import com.bokesoft.yes.parser.IExprDebugger;
import com.bokesoft.yes.parser.IFuncImplMap;
import com.bokesoft.yes.parser.Item;
import com.bokesoft.yes.parser.SyntaxTree;
import com.bokesoft.yigo.parser.IEvalContext;
import java.util.Objects;

public final class ExprDebuggerProxy {
    private static IExprDebugger exprDebugger;

    private ExprDebuggerProxy() {
    }

    public static <EC extends IEvalContext> void startExecSyntaxTree(IEvalEnv<EC> iEvalEnv, EC EC, IFuncImplMap iFuncImplMap, SyntaxTree syntaxTree, EvalScope evalScope) {
        if (Objects.isNull(exprDebugger)) {
            return;
        }
        try {
            exprDebugger.startExecSyntaxTree(iEvalEnv, EC, iFuncImplMap, syntaxTree, evalScope);
            return;
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public static <EC extends IEvalContext> void endExecSyntaxTree(IEvalEnv<EC> iEvalEnv, EC EC, SyntaxTree syntaxTree, EvalScope evalScope) {
        if (Objects.isNull(exprDebugger)) {
            return;
        }
        try {
            exprDebugger.endExecSyntaxTree(iEvalEnv, EC, syntaxTree, evalScope);
            return;
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public static <EC extends IEvalContext> void startExecItem(IEvalEnv<EC> iEvalEnv, EC EC, EvalScope evalScope, Item item) {
        if (Objects.isNull(exprDebugger)) {
            return;
        }
        try {
            exprDebugger.startExecItem(iEvalEnv, EC, evalScope, item);
            return;
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public static <EC extends IEvalContext> void endExecItem(IEvalEnv<EC> iEvalEnv, EC EC, EvalScope evalScope, Item item, Object object) {
        if (Objects.isNull(exprDebugger)) {
            return;
        }
        try {
            exprDebugger.endExecItem(iEvalEnv, EC, evalScope, item, object);
            return;
        }
        catch (Exception exception) {
            LogSvr.getInstance().error(exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    public static void setExprDebugger(IExprDebugger iExprDebugger) {
        if (Objects.nonNull(exprDebugger)) {
            throw new UnsupportedOperationException("Expr\u8c03\u8bd5\u5668\u91cd\u590d\u8bbe\u7f6e\uff01");
        }
        exprDebugger = iExprDebugger;
    }
}

