/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.document;

import com.bokesoft.yes.common.struct.MultiKey;
import com.bokesoft.yes.common.struct.MultiKeyNode;
import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.document.ExcelDataTable;
import com.bokesoft.yes.excel.document.ExcelDetailDataRow;
import com.bokesoft.yes.excel.document.ExcelExpandDataRow;
import com.bokesoft.yes.excel.document.ExcelGridInfo;
import com.bokesoft.yes.excel.document.ExcelGroupDataRow;
import com.bokesoft.yes.excel.document.ExcelGroupDetailRow;
import com.bokesoft.yes.excel.document.GroupInfo;
import com.bokesoft.yes.excel.document.IExcelDataRow;
import com.bokesoft.yes.excel.parser.ExcelContext;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExcelDocumentProcess {
    private ExcelWorkbook workbook;
    private Document document;
    private HashMap<String, ExcelDataTable> excelDataTableMap = new HashMap();
    private MetaDataObject metaDataObject;
    private ExcelContext excelContext;

    public ExcelDocumentProcess(MetaDataObject metaDataObject, ExcelWorkbook excelWorkbook, Document document, ExcelContext excelContext) {
        this.workbook = excelWorkbook;
        this.document = document;
        this.metaDataObject = metaDataObject;
        this.excelContext = excelContext;
    }

    public void process() {
        Iterator<ExcelSheet> iterator = this.workbook.iterator();
        while (iterator.hasNext()) {
            ExcelSheet excelSheet = iterator.next();
            for (ExcelGridInfo excelGridInfo : excelSheet.getGridInfoList()) {
                this.processExcelGrid(excelSheet, this.document, excelGridInfo);
            }
        }
        this.excelContext.setExcelDataTableMap(this.excelDataTableMap);
    }

    /*
     * WARNING - void declaration
     */
    private void processExcelGrid(ExcelSheet object, Document object2, ExcelGridInfo excelGridInfo) {
        Object object3;
        String string22;
        object = excelGridInfo.getTableKey();
        if (StringUtil.isBlankOrNull((String)object)) {
            return;
        }
        MetaColumn metaColumn22 = this.metaDataObject.getMetaTable((String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object4 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (String string22 : excelGridInfo.getGroupFieldList()) {
            arrayList2.add(DBTypeUtil.dataType2JavaDataType((int)((MetaColumn)metaColumn22.get(string22)).getDataType()));
        }
        Object object5 = this.excelDataTableMap.get(object);
        if (!this.excelDataTableMap.containsKey(object)) {
            object5 = new ExcelDataTable();
            this.excelDataTableMap.put((String)object, (ExcelDataTable)object5);
        }
        int n = (string22 = object2.get((String)object)) == null ? 0 : string22.size();
        for (MetaColumn metaColumn22 : metaColumn22) {
            if (!metaColumn22.getIsPrimary().booleanValue()) continue;
            arrayList.add(metaColumn22.getBindingDBColumnName());
            ((ArrayList)object4).add(DBTypeUtil.dataType2JavaDataType((int)metaColumn22.getDataType()));
        }
        object2 = arrayList.toArray(new String[0]);
        metaColumn22 = ((ArrayList)object4).toArray(new Integer[0]);
        for (int i = 0; i < n; ++i) {
            if (excelGridInfo.isColumnExpand()) {
                void var10_15;
                object4 = this.makeMultiKey((DataTable)string22, i, (String[])object2, (Integer[])metaColumn22);
                ExcelExpandDataRow excelExpandDataRow = ((ExcelDataTable)object5).getExpandRow((MultiKey)object4);
                if (excelExpandDataRow == null) {
                    ExcelExpandDataRow excelExpandDataRow2 = new ExcelExpandDataRow();
                    ((ExcelDataTable)object5).addExpandDataRow((MultiKey)object4, excelExpandDataRow2);
                }
                object3 = new ExcelDetailDataRow();
                ((ExcelDetailDataRow)object3).setRowIndex(i);
                var10_15.addDetailRow((IExcelDataRow)object3);
                continue;
            }
            if (excelGridInfo.isHasSum()) {
                void var10_22;
                Object object6;
                object4 = excelGridInfo.getGroupFieldList().toArray(new String[0]);
                Integer[] integerArray = arrayList2.toArray(new Integer[0]);
                object3 = this.makeMultiKey((DataTable)string22, i, (String[])object4, integerArray);
                object4 = ((ExcelDataTable)object5).getGroupRow((MultiKey)object3);
                Integer n2 = 1;
                if (object4 == null) {
                    object4 = new ExcelGroupDataRow();
                    for (Map.Entry entry : excelGridInfo.getGroupLevelMap().entrySet()) {
                        Object object7 = ((GroupInfo)entry.getValue()).getDefinition();
                        object7 = string22.getObject(i, (String)object7);
                        ((ExcelGroupDataRow)object4).addValueMap((Integer)entry.getKey(), object7);
                    }
                    ((ExcelDataTable)object5).addGroupDataRow((MultiKey)object3, (ExcelGroupDataRow)object4);
                    ((ExcelDataTable)object5).addGroupDataRowToList((ExcelGroupDataRow)object4);
                    Object object8 = ((ExcelGroupDataRow)object4).getValueMap().get(n2);
                    String string = TypeConvertor.toString((Object)n2) + "#" + TypeConvertor.toString((Object)object8);
                    this.addHeadGroupRow(excelGridInfo, n2, string, (ExcelGroupDataRow)object4);
                } else {
                    object6 = ((ExcelGroupDataRow)object4).getDetailRows();
                    String string = ((ExcelDetailDataRow)((ExcelGroupDataRow)object4).getRow(((ArrayList)object6).size() - 1)).getSign(n2);
                }
                object6 = new ExcelDetailDataRow();
                ((ExcelDetailDataRow)object6).setRowIndex(i);
                ((ExcelDetailDataRow)object6).addSign(n2, (String)var10_22);
                ((ExcelDetailDataRow)object6).addDefinition(n2, excelGridInfo.getGroupLevelMap().get(n2).getDefinition());
                ((ExcelGroupDataRow)object4).addDetailRow((IExcelDataRow)object6);
                continue;
            }
            object4 = new ExcelDetailDataRow();
            ((ExcelDetailDataRow)object4).setRowIndex(i);
            ((ExcelDataTable)object5).addDetailRow((ExcelDetailDataRow)object4);
        }
        for (ExcelGroupDataRow excelGroupDataRow : ((ExcelDataTable)object5).getGroupList()) {
            object3 = 1;
            this.addTailGroupRow(excelGridInfo, (Integer)object3, excelGroupDataRow);
        }
        this.groupRowProcess(excelGridInfo, (ExcelDataTable)object5);
    }

    private void groupRowProcess(ExcelGridInfo excelGridInfo, ExcelDataTable excelDataTable) {
        Iterator<Map.Entry<Integer, GroupInfo>> iterator = excelGridInfo.getGroupLevelMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Integer object = iterator.next().getKey();
            boolean bl = excelGridInfo.getGroupLevelMap().entrySet().size() > 1;
            if (bl && object == 1) continue;
            this.buildDetailRowAndGroupRow(object, excelGridInfo, excelDataTable, bl);
        }
        if (excelDataTable.getSortList() != null) {
            for (ExcelGroupDataRow excelGroupDataRow : excelDataTable.getSortList()) {
                excelDataTable.addAllDetailRow(excelGroupDataRow);
            }
        }
    }

    private void buildDetailRowAndGroupRow(Integer n, ExcelGridInfo excelGridInfo, ExcelDataTable excelDataTable, boolean bl) {
        HashMap<String, ExcelGroupDataRow> hashMap = new HashMap<String, ExcelGroupDataRow>();
        ArrayList<ExcelGroupDataRow> arrayList = new ArrayList<ExcelGroupDataRow>();
        Object object = excelDataTable.getSortMap() == null ? excelDataTable.getGroupList() : excelDataTable.getSortList();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            ExcelGroupDataRow excelGroupDataRow = (ExcelGroupDataRow)object.next();
            Object object2 = excelGroupDataRow.getValueMap().get(n);
            String string = TypeConvertor.toString((Object)n) + "#" + TypeConvertor.toString((Object)object2);
            object2 = this.createMapKey(excelGroupDataRow.valueMapIterator(), n, object2);
            ExcelGroupDataRow excelGroupDataRow2 = hashMap.get(object2);
            if (excelGroupDataRow2 == null) {
                excelGroupDataRow2 = new ExcelGroupDataRow();
                hashMap.put((String)object2, excelGroupDataRow2);
                arrayList.add(excelGroupDataRow2);
                if (bl) {
                    excelGroupDataRow2.addAllValueMap(excelGroupDataRow.getValueMap());
                    this.addHeadGroupRow(excelGridInfo, n, string, excelGroupDataRow2);
                }
            }
            Iterator<IExcelDataRow> object22 = excelGroupDataRow.iterator();
            while (object22.hasNext()) {
                object2 = object22.next();
                if (object2.getType().equalsIgnoreCase("Detail")) {
                    ExcelDetailDataRow excelDetailDataRow = (ExcelDetailDataRow)object2;
                    excelDetailDataRow.addSign(n, string);
                    excelDetailDataRow.addDefinition(n, excelGridInfo.getGroupLevelMap().get(n).getDefinition());
                }
                excelGroupDataRow2.addDetailRow((IExcelDataRow)object2);
            }
        }
        excelDataTable.setSortMap(hashMap);
        excelDataTable.setSortList(arrayList);
        if (!bl) {
            return;
        }
        for (ExcelGroupDataRow excelGroupDataRow : arrayList) {
            this.addTailGroupRow(excelGridInfo, n, excelGroupDataRow);
        }
    }

    private String createMapKey(Iterator<Map.Entry<Integer, Object>> iterator, Integer n, Object object) {
        String string = n + "#" + object;
        while (iterator.hasNext()) {
            object = iterator.next();
            Integer n2 = object.getKey();
            object = object.getValue();
            if (n2 <= n) continue;
            string = n2 + "#" + object + "-" + string;
        }
        return string;
    }

    private void addHeadGroupRow(ExcelGridInfo object, Integer n, String string, ExcelGroupDataRow excelGroupDataRow) {
        if ((object = ((ExcelGridInfo)object).getGroupLevelMap().get(n)) == null) {
            return;
        }
        String string2 = ((GroupInfo)object).getGroupPosition();
        if ("head".equalsIgnoreCase(string2) || "all".equalsIgnoreCase(string2)) {
            int n2 = ((GroupInfo)object).getGroupHeadRowCount();
            for (int i = 1; i <= n2; ++i) {
                ExcelGroupDetailRow excelGroupDetailRow = new ExcelGroupDetailRow();
                excelGroupDetailRow.setGroupLevel(n);
                excelGroupDetailRow.setExcelRow(((GroupInfo)object).getExcelRow());
                excelGroupDetailRow.setSign(string);
                excelGroupDetailRow.setDefinition(((GroupInfo)object).getDefinition());
                excelGroupDataRow.addDetailRow(excelGroupDetailRow);
            }
        }
    }

    private void addTailGroupRow(ExcelGridInfo excelGridInfo, Integer n, ExcelGroupDataRow excelGroupDataRow) {
        Object object;
        Object object2 = excelGroupDataRow.getValueMap().get(n);
        object2 = TypeConvertor.toString((Object)n) + "#" + TypeConvertor.toString((Object)object2);
        Object object3 = new ArrayList<Object>();
        ArrayList<IExcelDataRow> arrayList = new ArrayList<IExcelDataRow>();
        Object object4 = excelGroupDataRow.iterator();
        while (object4.hasNext()) {
            object = object4.next();
            if (object.getType().equalsIgnoreCase("GroupDetail")) {
                ((ArrayList)object3).add(object);
                continue;
            }
            arrayList.add((IExcelDataRow)object);
        }
        object = ((ArrayList)object3).iterator();
        while (object.hasNext()) {
            object4 = (ExcelGroupDetailRow)((IExcelDataRow)object.next());
            if (!((ExcelGroupDetailRow)object4).getSign().equalsIgnoreCase((String)object2)) continue;
            ((ExcelGroupDetailRow)object4).setDetailRows(arrayList);
        }
        object3 = excelGridInfo.getGroupLevelMap().get(n);
        object4 = ((GroupInfo)object3).getGroupPosition();
        if ("tail".equalsIgnoreCase((String)object4) || "all".equalsIgnoreCase((String)object4)) {
            int n2 = ((GroupInfo)object3).getGroupTailRowCount();
            for (int i = 1; i <= n2; ++i) {
                object = new ExcelGroupDetailRow();
                ((ExcelGroupDetailRow)object).setGroupLevel(n);
                ((ExcelGroupDetailRow)object).setExcelRow(((GroupInfo)object3).getExcelRow());
                ((ExcelGroupDetailRow)object).setSign((String)object2);
                ((ExcelGroupDetailRow)object).setDefinition(((GroupInfo)object3).getDefinition());
                ((ExcelGroupDetailRow)object).setDetailRows(arrayList);
                excelGroupDataRow.addDetailRow((IExcelDataRow)object);
            }
        }
    }

    private MultiKey makeMultiKey(DataTable dataTable, int n, String[] stringArray, Integer[] integerArray) {
        MultiKey multiKey = new MultiKey();
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            multiKey.addValue(new MultiKeyNode(integerArray[i].intValue(), dataTable.getObject(n, stringArray[i])));
        }
        return multiKey;
    }

    public ExcelDataTable getExcelDataTable(String string) {
        return this.excelDataTableMap.get(string);
    }
}

