/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.BaseOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateColumn;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SingleOutputStrategy
extends BaseOutputStrategy {
    public SingleOutputStrategy(Workbook workbook, StampExcelStyleFactory stampExcelStyleFactory, ExcelTemplate excelTemplate) {
        super(workbook, stampExcelStyleFactory, excelTemplate);
    }

    @Override
    public void preOutputSheet(OutputSheetProcess object) {
        super.preOutputSheet((OutputSheetProcess)object);
        for (ExcelTemplateColumn excelTemplateColumn : this.curSheetTemplate.getColumns()) {
            this.curSheet.setColumnWidth(excelTemplateColumn.getIndex(), (excelTemplateColumn.getWidth() << 8) / 7 + 500);
        }
    }

    @Override
    public void insertRow(int n, OutputRowProcess outputRowProcess) {
        n = outputRowProcess.getTemplateTable().getStartDtlRowIndex() + n + 1;
        super.insertRow(n, outputRowProcess);
        Row row = ExcelUtil.getRow((Sheet)this.curSheet, (int)n);
        int n2 = outputRowProcess.getTemplateTable().getRowHeight();
        if (n2 >= 0) {
            row.setHeightInPoints((float)n2);
        }
    }

    @Override
    public void outputCell(Object object, int n, int n2, ExcelTemplateField excelTemplateField, boolean bl) {
        this.setCellValue(object, n += excelTemplateField.getRowIndex() + (bl ? 1 : 0), n2, excelTemplateField);
    }

    @Override
    public void postOutputExcel(ExcelTemplate excelTemplate) {
    }
}

