/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputSheetProcess;
import com.bokesoft.yes.excel.cmd.stamp.output.strategy.IOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class BaseOutputStrategy
implements IOutputStrategy {
    protected Workbook workbook = null;
    private StampExcelStyleFactory styleFactory = null;
    protected Sheet curSheet = null;
    protected Sheet sysSheet = null;
    protected ExcelTemplateSheet curSheetTemplate = null;
    protected ExcelTemplate excelSheetTemplate = null;

    public BaseOutputStrategy(Workbook workbook, StampExcelStyleFactory stampExcelStyleFactory, ExcelTemplate excelTemplate) {
        this.workbook = workbook;
        this.styleFactory = stampExcelStyleFactory;
        this.excelSheetTemplate = excelTemplate;
        this.sysSheet = ExcelUtil.getSheet((Workbook)workbook, (String)"YIGO_TEMPLATE");
    }

    @Override
    public void preOutputSheet(OutputSheetProcess outputSheetProcess) {
        this.curSheetTemplate = outputSheetProcess.getTemplateSheet();
        this.curSheet = ExcelUtil.getSheet((Workbook)this.workbook, (String)this.curSheetTemplate.getSheetName());
    }

    @Override
    public void insertRow(int n, OutputRowProcess outputRowProcess) {
        ExcelUtil.insertRow((Sheet)this.curSheet, (int)n);
    }

    protected void setCellValue(Object object, int n, int n2, ExcelTemplateField excelTemplateField) {
        ExcelUtil.setCellValue((Sheet)this.curSheet, (int)n, (int)n2, (Object)object, (ExcelTemplateField)excelTemplateField, (StampExcelStyleFactory)this.styleFactory);
    }
}

