/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp.input.strategy;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InTable4Expand;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InTable4Normal;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.cmd.stamp.input.strategy.IInputStrategy;
import com.bokesoft.yes.excel.cmd.stamp.input.strategy.InDocumentListIterator;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SingleInputStrategy
implements IInputStrategy {
    private ExcelTemplate excelTemplate = null;
    private IInputReaderBag workbookReader = null;
    private List<IInDocument<IInTable>> listInDocument = null;
    private ExcelProcessContext excelProcessContext = null;

    public SingleInputStrategy(ExcelTemplate excelTemplate, IInputReaderBag iInputReaderBag, ExcelProcessContext excelProcessContext) {
        this.excelTemplate = excelTemplate;
        this.workbookReader = iInputReaderBag;
        this.listInDocument = new ArrayList<IInDocument<IInTable>>();
        this.excelProcessContext = excelProcessContext;
        this.init();
    }

    private void init() {
        this.listInDocument.add(this.getInDocument());
    }

    private InDocument<IInTable> getInDocument() {
        InDocument<IInTable> inDocument = new InDocument<IInTable>("", this.workbookReader);
        for (Object object : this.excelTemplate.getTemplateTables4StampImport()) {
            int n = object.getStartDtlRowIndex();
            if (object.isDtlTable()) {
                int n2;
                for (n2 = n + 1; n2 <= this.workbookReader.getLastRowNum(object.getSheetName()) && !this.workbookReader.isEmptySheetRow(object.getSheetName(), n2); ++n2) {
                }
                object = object.hasExpandField() ? new InTable4Expand((ExcelTemplateTable)object, n + 1, n2, this.workbookReader) : new InTable4Normal((ExcelTemplateTable)object, n + 1, n2, this.workbookReader);
            } else {
                int n3 = n;
                object = new InTable4Normal((ExcelTemplateTable)object, n3, n3, this.workbookReader);
            }
            inDocument.addTable((IInTable)object);
        }
        return inDocument;
    }

    @Override
    public Iterator<IInDocument<IInTable>> iterator() {
        return new InDocumentListIterator(this.listInDocument);
    }
}

