/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.stamp;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.dts.util.FileUtil;
import com.bokesoft.yes.excel.cmd.stamp.input.ImportExcelWithStampService;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.util.CmdUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.excel.IImportService;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaImportService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.File;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImportExcelWithStampCmd
extends DefaultServiceCmd {
    private String formKey = null;
    private List<FileData> fileDatas = null;
    private boolean clearOriginalData = true;
    private String importServiceName = null;
    private String postImportServiceName = null;
    private boolean isDocTypeDict = false;
    private Document document = null;

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.formKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"formKey"));
        this.fileDatas = (List)stringHashMap.get((Object)"fileDatas");
        this.clearOriginalData = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"clearOriginalData"));
        this.postImportServiceName = TypeConvertor.toString((Object)stringHashMap.get((Object)"postImportServiceName"));
        this.importServiceName = TypeConvertor.toString((Object)stringHashMap.get((Object)"importServiceName"));
        this.document = CmdUtil.resolveDocument((DefaultContext)defaultContext, (String)TypeConvertor.toString((Object)stringHashMap.get((Object)"document")));
        if (stringHashMap.containsKey((Object)"isDocTypeDict")) {
            this.isDocTypeDict = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"isDocTypeDict"));
        }
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        FileData fileData2;
        Object object;
        StringBuilder stringBuilder;
        MetaEnhance metaEnhance;
        if (this.fileDatas == null || this.fileDatas.isEmpty()) {
            return null;
        }
        defaultContext.setFormKey(this.formKey);
        Object object2 = null;
        if (this.importServiceName != null && !this.importServiceName.isEmpty() && (metaEnhance = defaultContext.getVE().getMetaFactory().getEnhance(null)) != null) {
            MetaImportService metaImportService = null;
            stringBuilder = metaEnhance.getExtImportService();
            if (stringBuilder != null) {
                metaImportService = (MetaImportService)stringBuilder.get(this.importServiceName);
            }
            if (metaImportService != null) {
                object = metaImportService.getImpl();
                object2 = ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)object);
            }
        }
        if (object2 == null) {
            object2 = new ImportExcelWithStampService(this.document);
        }
        int n = 0;
        int n2 = 0;
        stringBuilder = new StringBuilder("");
        for (FileData fileData2 : this.fileDatas) {
            JSONObject jSONObject = this.importData(defaultContext, object2, fileData2, this.clearOriginalData, this.postImportServiceName);
            if (jSONObject.has("CheckError")) {
                stringBuilder.append("import check failed:").append(fileData2.getFileName()).append("\r\n");
                stringBuilder.append(jSONObject.get("CheckError"));
                this.logCheckError(fileData2.getFileName(), jSONObject);
                continue;
            }
            JSONArray jSONArray = (JSONArray)jSONObject.get("Fail");
            jSONObject = (JSONArray)jSONObject.get("Success");
            n2 += jSONArray.length();
            n += jSONObject.length();
            this.log(fileData2.getFileName(), jSONArray, (JSONArray)jSONObject);
        }
        object = new StringBuilder("");
        if (n2 == 0) {
            ((StringBuilder)object).append("import excel successed,");
        } else {
            ((StringBuilder)object).append("import excel failed,");
        }
        ((StringBuilder)object).append(" successed:").append(n).append(" failed:").append(n2);
        fileData2 = new JSONObject();
        if (this.document != null) {
            fileData2.put("document", (Object)this.document.toJSON());
        }
        if (stringBuilder.length() > 0) {
            fileData2.put("error", (Object)stringBuilder.toString());
        }
        fileData2.put("result", (Object)((StringBuilder)object).toString());
        return fileData2;
    }

    private JSONObject importData(DefaultContext object, Object object2, FileData object3, boolean bl, String string) throws Throwable {
        block8: {
            block9: {
                if (!(object2 instanceof IImportService)) break block9;
                object3 = FileUtil.createTempFile((FileData)object3, "Import");
                try {
                    object = ((IImportService)object2).importData((DefaultContext)object, (File)object3, bl, string);
                }
                catch (Throwable throwable) {
                    try {
                        if (object3 != null) {
                            ((File)object3).delete();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (object3 != null) {
                        ((File)object3).delete();
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break block8;
            }
            ((IImportService2)object2).setFormKey(this.formKey);
            ((IImportService2)object2).setClearOriginalData(bl);
            ((IImportService2)object2).setPostServiceName(string);
            object = ((IImportService2)object2).importData((DefaultContext)object, object3.getData());
        }
        return (JSONObject)object;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new ImportExcelWithStampCmd();
    }

    public String getCmd() {
        return "ImportExcelWithStamp";
    }

    public void setClearOriginalData(boolean bl) {
        this.clearOriginalData = bl;
    }

    public void setImportServiceName(String string) {
        this.importServiceName = string;
    }

    public void setFileDatas(List<FileData> list) {
        this.fileDatas = list;
    }

    public void setFormKey(String string) {
        this.formKey = string;
    }

    public boolean getNeedServiceRight() {
        return true;
    }

    private void log(String string, JSONArray jSONArray, JSONArray jSONArray2) {
        if (jSONArray.length() > 0) {
            LogSvr.getInstance().info("import excel failed: ".concat(String.valueOf(string)));
            LogSvr.getInstance().info("import excel failed: ".concat(String.valueOf(jSONArray)));
        }
        if (jSONArray2 != null && jSONArray2.length() > 0) {
            LogSvr.getInstance().info("import excel successed: ".concat(String.valueOf(string)));
            LogSvr.getInstance().info("import excel successed: ".concat(String.valueOf(jSONArray2)));
        }
    }

    private void logCheckError(String string, Object object) {
        LogSvr.getInstance().info("import excel check error: ".concat(String.valueOf(string)));
        LogSvr.getInstance().info("import excel check error: ".concat(String.valueOf(object)));
    }

    private void copyJSONArray(JSONArray jSONArray, JSONArray jSONArray2) {
        for (int i = 0; i < jSONArray2.length(); ++i) {
            jSONArray.put(jSONArray2.get(i));
        }
    }
}

