/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yes.excel.cmd.normal.IImport;
import com.bokesoft.yes.excel.cmd.normal.ImportDictionary;
import com.bokesoft.yes.excel.cmd.normal.ImportDictionaryWithDoc;
import com.bokesoft.yes.excel.cmd.normal.ImportExcel4Bill;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ImportUtil {
    private DefaultContext context = null;
    private byte[] bytes = null;
    private String formKey = null;
    private boolean clearOriginalData = false;
    private String postServiceName = null;
    private boolean isDocTypeDict = false;

    public ImportUtil(DefaultContext defaultContext, byte[] byArray) {
        this.context = defaultContext;
        this.bytes = byArray;
    }

    public Object initImport() throws Throwable {
        DefaultContext defaultContext = new DefaultContext(this.context);
        defaultContext.setParas(this.context.getParas());
        Workbook workbook = WorkbookFactory.create((InputStream)new ByteArrayInputStream(this.bytes));
        MetaDataObject metaDataObject = this.getDataObject(defaultContext, workbook);
        int n = metaDataObject.getPrimaryType();
        int n2 = metaDataObject.getSecondaryType();
        IImport iImport = null;
        if (n == 0) {
            switch (n2) {
                case 2: {
                    iImport = (IImport)this.importExcel(defaultContext, workbook, this.postServiceName);
                    break;
                }
                case 3: 
                case 5: {
                    iImport = this.isDocTypeDict ? (IImport)this.importDocTypeDict(defaultContext, workbook, this.postServiceName, this.clearOriginalData) : (IImport)this.importDict(defaultContext, workbook, this.clearOriginalData, this.postServiceName);
                }
            }
        }
        return iImport;
    }

    private MetaDataObject getDataObject(DefaultContext defaultContext, Workbook object) throws Throwable {
        object = ExcelUtil.getCellValue((Sheet)object.getSheetAt(0), (int)0, (int)0).toString();
        if ((defaultContext = defaultContext.getVE().getMetaFactory().getDataObject((String)object)) == null) {
            throw new MidCoreException(50, MidCoreException.formatMessage(null, (int)50, (Object[])new Object[]{object}));
        }
        return defaultContext;
    }

    private Object importExcel(DefaultContext defaultContext, Workbook workbook, String string) {
        ImportExcel4Bill importExcel4Bill = null;
        try {
            importExcel4Bill = new ImportExcel4Bill(defaultContext, workbook, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return importExcel4Bill;
    }

    private Object importDict(DefaultContext defaultContext, Workbook workbook, boolean bl, String string) {
        ImportDictionary importDictionary = null;
        try {
            importDictionary = new ImportDictionary(defaultContext, workbook, bl, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return importDictionary;
    }

    private Object importDocTypeDict(DefaultContext defaultContext, Workbook workbook, String string, boolean bl) {
        ImportDictionaryWithDoc importDictionaryWithDoc = null;
        try {
            importDictionaryWithDoc = new ImportDictionaryWithDoc(defaultContext, workbook, string, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return importDictionaryWithDoc;
    }

    public void setClearOriginalData(boolean bl) {
        this.clearOriginalData = bl;
    }

    public void setPostServiceName(String string) {
        this.postServiceName = string;
    }

    public void setFormKey(String string) {
        this.formKey = string;
    }

    public void setDocTypeDict(boolean bl) {
        this.isDocTypeDict = bl;
    }
}

