/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.describe;

import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class DescribeBuilder {
    private static final String TABLES = "formTable";
    private static final String DB_TABLES = "formDbTable";
    private static final String FORM_KEY = "formKey";
    private static final String FORM_TYPE = "formType";
    private static final String DATAOBJECT_KEY = "dataObjectKey";
    private static final String COLUMN_DB = "dbColumnName";
    private static final String COLUMN_TYPE = "dataType";
    private static final String COLUMN_CAPTION = "caption";
    private static final String COLUMN_KEY = "key";
    private static final String COLUMN_ITEMKEY = "itemKey";
    private static final String COLUMN_DICTABLE = "dicTable";
    private DefaultContext context = null;
    Map<String, Map<String, String>> dictMap = null;

    public DescribeBuilder(DefaultContext defaultContext) {
        this.context = defaultContext;
    }

    public JSONObject getDescribe(MetaForm metaForm) throws Throwable {
        this.buildDictMap(metaForm);
        MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
        JSONObject jSONObject = new JSONObject();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = true;
        for (MetaTable metaTable : metaDataObject.getTableCollection()) {
            String string = metaTable.getKey();
            String string2 = metaTable.getDBTableName();
            if (string2 == null || string2.isEmpty()) {
                string2 = string;
            }
            if (bl) {
                bl = false;
                stringBuffer.append(string);
                stringBuffer2.append(string2);
            } else {
                stringBuffer.append(",").append(string);
                stringBuffer2.append(",").append(string2);
            }
            metaTable = this.getTableDescribe(metaTable);
            jSONObject.put(string, (Object)metaTable);
        }
        jSONObject.put(TABLES, (Object)stringBuffer.toString());
        jSONObject.put(DB_TABLES, (Object)stringBuffer2.toString());
        jSONObject.put(FORM_KEY, (Object)metaForm.getKey());
        jSONObject.put(DATAOBJECT_KEY, (Object)metaForm.getDataSource().getDataObject().getKey());
        jSONObject.put(FORM_TYPE, (Object)FormType.toString((Integer)metaForm.getFormType()));
        return jSONObject;
    }

    private JSONArray getTableDescribe(MetaTable metaTable) throws Throwable {
        JSONArray jSONArray = new JSONArray();
        for (MetaColumn metaColumn : metaTable) {
            metaColumn = this.getColumnDescribe(metaColumn, this.dictMap.get(metaTable.getKey()));
            jSONArray.put((Object)metaColumn);
        }
        return jSONArray;
    }

    private JSONObject getColumnDescribe(MetaColumn object, Map<String, String> map) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        String string = object.getDBColumnName();
        if (string == null || string.isEmpty()) {
            jSONObject.put(COLUMN_DB, (Object)object.getKey());
        } else {
            jSONObject.put(COLUMN_DB, (Object)object.getDBColumnName());
        }
        jSONObject.put(COLUMN_TYPE, (Object)DataType.toString((Integer)object.getDataType()));
        jSONObject.put(COLUMN_CAPTION, (Object)object.getCaption());
        jSONObject.put(COLUMN_KEY, (Object)object.getKey());
        if (map != null) {
            if ((object = map.get(object.getKey())) != null) {
                jSONObject.put(COLUMN_ITEMKEY, object);
            }
            if ((object = this.getDictTable((String)object)) != null) {
                jSONObject.put(COLUMN_DICTABLE, object);
            }
        }
        return jSONObject;
    }

    private void buildDictMap(MetaForm metaForm) {
        String string;
        Map<String, String> map;
        MetaGridRow metaGridRow;
        this.dictMap = new HashMap<String, Map<String, String>>();
        for (Object object : metaForm.getAllComponents()) {
            if (!(object instanceof MetaGrid)) continue;
            object = ((MetaGrid)object).getRowCollection().iterator();
            while (object.hasNext()) {
                metaGridRow = (MetaGridRow)object.next();
                for (String string2 : metaGridRow) {
                    if (string2.getCellType() != 206) continue;
                    map = string2.getDataBinding().getColumnKey();
                    string2 = ((MetaDictProperties)string2.getProperties()).getItemKey();
                    string = metaGridRow.getTableKey();
                    Map<String, String> map2 = this.dictMap.get(string);
                    if (map2 == null) {
                        map2 = new HashMap<String, String>();
                        this.dictMap.put(string, map2);
                    }
                    map2.put((String)((Object)map), string2);
                }
            }
        }
        for (Object object : metaForm.getAllComponents()) {
            String string2;
            if (!(object instanceof MetaDict)) continue;
            object = (MetaDict)object;
            metaGridRow = object.getDataBinding();
            String string3 = metaGridRow.getTableKey();
            string2 = metaGridRow.getColumnKey();
            string = object.getItemKey();
            map = this.dictMap.get(string3);
            if (map == null) {
                map = new HashMap<String, String>();
                this.dictMap.put(string3, map);
            }
            map.put(string2, string);
        }
    }

    private String getDictTable(String string) throws Throwable {
        string = this.context.getVE().getMetaFactory().getDataObject(string);
        if (string == null) {
            return null;
        }
        return string.getMainTable().getDBTableName();
    }
}

