package com.bokesoft.yigo.excel;

import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 导入二次开发接口,导入时通过反射调用
 */
public interface IImportService2 {
	
	/**
	 * 设置表单标识
	 * @param formKey 表单标识
	 */
	public void setFormKey(String formKey);
	
	/**
	 * 导入的具体实现方法
	 * @param context	上下文环境
	 * @param bytes		导入的文件
	 * @throws Throwable 
	 */
	public Object importData(DefaultContext context, byte[] bytes) throws Throwable;

	/**
	 * 是否清除旧数据
	 * @param clearOriginalData
	 */
	public void setClearOriginalData(boolean clearOriginalData);
	
	/**
	 * 导入完成后需要执行的二开
	 * @param postServiceName
	 */
	public void setPostServiceName(String postServiceName);

}
