package com.bokesoft.yes.report;

import java.util.LinkedList;

import com.bokesoft.yes.data.service.IDocumentService;
import com.bokesoft.yes.data.service.ModuleNameConstants;
import com.bokesoft.yes.data.service.DocumentServiceManager;
import com.bokesoft.yes.report.datasource.IImplReportDataSource;
import com.bokesoft.yes.report.fill.FillPolicy;
import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.proxy.IQueryProxy;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.report.MidReportProviderFactory;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.usrpara.Paras;
import com.bokesoft.yigo.tools.ve.VE;

/**
 * BatchReportFill根据表单标识，根据OID集合批量生成指定报表模板的报表。
 * @author wangyh
 *
 */
public class MidBatchReportFill {
	/** 虚拟环境 */
	private VE ve = null;
	/** 报表模板 */
	private MetaReport metaReport = null;
	/** 表单对象标识 */
	private String formKey = "";
	/** OID集合 */
	private LinkedList<Long> OIDList = null;
	/** 参数集*/
	private Paras paras = null;
	
	public MidBatchReportFill(VE ve, MetaReport metaReport, 
			String formKey, LinkedList<Long> OIDList, Paras paras) {
		this.ve = ve;
		this.metaReport = metaReport;
		this.formKey = formKey;
		this.OIDList = OIDList;
		this.paras = paras;
	}
	
	public OutputPageSet fill(DefaultContext context) throws Throwable {
		Document document = null;
		OutputPageSet result = new OutputPageSet();
		IDocumentService documentService = DocumentServiceManager.getInstance()
				.getDocumentService(context, ModuleNameConstants.PRINT, "MidBatchReportFill", formKey, metaReport.getKey());
		documentService.init(context, formKey, OIDList, false);
		while (documentService.hasNext()) {
			document = documentService.next();
			if (document != null) {
				DefaultContext newContext = new DefaultContext(context);
				fillPagesetWithDocument(document, result, newContext);
			}
		}
		return result;
	}
	
	private void fillPagesetWithDocument(Document document, OutputPageSet allPageSet, DefaultContext newContext) throws Throwable {
		OutputPageSet pageSet = new OutputPageSet();
		IQueryProxy queryProxy = new MidQueryProxy(newContext, formKey);
		IImplReportDataSource dataSource = new ReportDataSource(ve, queryProxy, document, paras, formKey, null);

		//根据formKey和document获取对应的打印模版
		MetaReport tempMetaReport = MidReportProviderFactory.getMetaReport(newContext, formKey, document);
		if(tempMetaReport != null){
			metaReport = tempMetaReport;
		}

		FillPolicy policy = new FillPolicy(metaReport, dataSource, paras);
		policy.fill(pageSet);
		allPageSet.addAll(pageSet);
		allPageSet.setTitle(pageSet.getTitle());
	}
}
