package com.bokesoft.yes.excel.utils;

import java.io.ByteArrayOutputStream;

import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.struct.filedata.FileData;

public class XlsxToFileDataUtil {
	public FileData convertToFileData(String fileName, Workbook workbook) throws Throwable {
		ByteArrayOutputStream bos = null;
		try{
			bos = new ByteArrayOutputStream();
			workbook.write(bos);
			FileData fileData = new FileData();
			fileData.setData(bos.toByteArray());
			fileData.setFileName(fileName);
			return fileData;
		} finally {
			if(bos != null){
				bos.close();
			}
			if(workbook != null){
				workbook.close();
			}
		}
	}
}
