package com.bokesoft.yes.excel.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import com.bokesoft.yigo.common.def.OperationState;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.common.util.DBTypeUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.DictStateMask;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;

public class ImportBillHandler {
	private IMetaFactory metaFactory = null;
	
	private String dataObjectKey = null;

	private HashMap<String, List<String>> importFields = null;

	private Workbook workbook = null;

	private Sheet mainSheet = null;

	private MetaDataObject metaDataObject = null;

	private DefaultContext context = null;
	
	public static String SEPARATOR = ";";

	public ImportBillHandler(DefaultContext context, Workbook workbook) throws Throwable {
		this.metaFactory = context.getVE().getMetaFactory();
		this.workbook = workbook;
		this.context = context;
		init(context);
	}

	private void init(DefaultContext context) throws Throwable {
		// 第一个sheet中存储ItemKey
		mainSheet = workbook.getSheetAt(0);
		dataObjectKey = ExcelUtil.getCellValue(mainSheet, 0, 0).toString();
		metaDataObject =context.getVE().getMetaFactory().getDataObject(dataObjectKey);

		Sheet sheet = null;
		String tableKey = null;
		ArrayList<String> list = null;
		importFields = new HashMap<String, List<String>>();
		int sheetCount = workbook.getNumberOfSheets();
		for (int i = 0; i < sheetCount; i++) {
			sheet = workbook.getSheetAt(i);
			tableKey = sheet.getSheetName();
			list = new ArrayList<String>();
			importFields.put(tableKey, list);

			int colIndex = 1;
			while (true) {
				String fieldKey = ExcelUtil.getCellValue(sheet, 0, colIndex).toString();
				if (fieldKey.isEmpty()) {
					break;
				}
				list.add(fieldKey);
				colIndex++;
			}
		}
	}

	public String getDataObjectKey() {
		return dataObjectKey;
	}

	public MetaDataObject getDataObject() {
		return metaDataObject;
	}

	public HashMap<String, List<String>> getImportFields() {
		return importFields;
	}

	public List<String> getFieldsByTable(String tableKey) {
		return importFields.get(tableKey);
	}

	public Sheet getMainSheet() throws Throwable {
		return mainSheet;
	}

	// 填充导入的字段
	public void fillImportField(MetaTable metaTable, DataTable dataTable, Sheet sheet, int rowIndex) throws Throwable {
		List<String> fields = getFieldsByTable(metaTable.getKey());
		for (int colIndex = 0; colIndex < fields.size(); colIndex++) {
			String columnKey = fields.get(colIndex);
			String[] columnKeys = columnKey.split(ImportDictionaryHander.SEPARATOR);
			
			Object value = getValue(metaTable, sheet, rowIndex, colIndex + 1, columnKey);
			
			dataTable.setObject(columnKeys[0], value);
		}
	}

	// 从Excel中获取导入的值，根据字段类型做转换
	private Object getValue(MetaTable metaTable, Sheet sheet, int rowIndex, int colIndex, String fieldKey) throws Throwable {
		Object value = ExcelUtil.getCellValue(sheet, rowIndex, colIndex);
		//字典导入的Code全部转化为大写
		if (fieldKey.equals("Code")){
			value = value.toString().toUpperCase();
		}
		String columnKey = null;
		String[] fields = fieldKey.split(ImportDictionaryHander.SEPARATOR);
		columnKey = fields[0];
		// 根据数DataType转型
		MetaColumn column = metaTable.get(columnKey);
		if( column == null ) {
			throw new MidCoreException(MidCoreException.IMPORT_COLUMN_UNDEFINED,
					MidCoreException.formatMessage(null, MidCoreException.IMPORT_COLUMN_UNDEFINED, columnKey));
		}
		
		if (value != null && !value.toString().isEmpty()) {
			String sValue = TypeConvertor.toString(value);
			if (fields.length > 1) {
				value = 0;
				String itemKey = fields[1];
				IDictCacheProxy dictCache = context.getDictCache();
				MetaDataObject dictDataObject = metaFactory.getDataObject(itemKey);
				if (dictDataObject == null) {
					throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, 
							SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), itemKey));
				}				
				List<MetaColumn> displayColumns = dictDataObject.getDisplayColumns();
				for (MetaColumn metaColumn : displayColumns) {
					if(sValue.contains(",") && column.getDataType() == DataType.STRING){
						List<Item> dictRowCount = dictCache.getAllItems(itemKey,null, 0, 0);
						String[] strArray = sValue.split(",");
						//如果导入模板数据个数和数据库字典数据个数相同则显示全选
						if (dictRowCount.size() == strArray.length){
							value = 0;
						}else{
							String tempValue = "";
							for(int i=0;i<strArray.length;i++){
								Item item = dictCache.locate(itemKey, metaColumn.getKey(), strArray[i], null, null, DictStateMask.All, OperationState.Default);
								if (item != null) {
									if (i != 0){
										value = item.getID();
										tempValue = tempValue +","+ value.toString();
									}else{
										value = item.getID();
										tempValue = value.toString();
									}
								}
							}
							value =(Object)tempValue;
						}
					}else{
						Item item = dictCache.locate(itemKey, metaColumn.getKey(), sValue, null, null, DictStateMask.All, OperationState.Default);
						if (item != null) {
							value = item.getID();
							break;
						}
					}
					if (!StringUtil.isBlankOrNull(value)) {
						break;
					}
				}
			}
		}

		return TypeConvertor.toJavaType(DBTypeUtil.dataType2JavaDataType(column.getDataType()), value);
	}
	
	public String getPrimayKey(Sheet sheet, int rowIndex, boolean isMainTable) {
		return ExcelUtil.getCellValue(sheet, rowIndex, 0).toString();
	}
}
