package com.bokesoft.yes.excel.transformer;

import java.util.List;

import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelFormat;
import com.bokesoft.yes.excel.template.ExcelListItem;
import com.bokesoft.yes.tools.dic.proxy.IDictCacheProxy;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.dict.DictCacheProxyFactory;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.ve.VE;

public class ExcelDictDataTransformer implements IExcelTransformer {
	private VE ve = null;
	
	private IDictCacheProxy dictCache = null;
	
	public ExcelDictDataTransformer(VE ve) {
		this.ve = ve;
		dictCache = DictCacheProxyFactory.getInstance().newProxy(ve);
	}
	
	@Override
	public Object transform(ExcelCell excelCell, Object value) {
		StringBuffer result = new StringBuffer(30);
		ExcelDisplay display = excelCell.getDisplay();
		if (display != null && display.getFormat() != null) {
			ExcelFormat format = display.getFormat();
			if (format.getDataType() == ExcelFormatDataType.Dict) {
				String itemKey = format.getItemKey();
				if (itemKey != null && !itemKey.isEmpty()) {
					try {
						if((value instanceof String)){
							String v = (String)value;
							String[] s = v.split(",");
							getDictString(result, s, itemKey, format.getFieldKeyList());
						}
						else{
							getDictString(result, value, itemKey, format.getFieldKeyList());
						}						
					} catch (Throwable e) {
						e.printStackTrace();
					}
				}
			}
		}
		
		return result.toString();
	}
	
	@Override
	public Object transform(int dataType, String itemKey, String fieldKeys, String formatString,
			List<ExcelListItem> listItems, Object value) {
		StringBuffer result = new StringBuffer(30);
		if (dataType == ExcelFormatDataType.Dict) {
			if (itemKey != null && !itemKey.isEmpty()) {
				try {
					if((value instanceof String)){
						String v = (String)value;
						String[] s = v.split(",");
						getDictString(result, s, itemKey, getFieldKeysArray(fieldKeys));
					}
					else{
						getDictString(result, value, itemKey, getFieldKeysArray(fieldKeys));
					}						
				} catch (Throwable e) {
					e.printStackTrace();
				}
			}
		}
		return result.toString();
	}
	
	private String[] getFieldKeysArray(String fieldKeys) {
		if (fieldKeys != null && !fieldKeys.isEmpty() ) {
			return fieldKeys.split(",");
		}
		return null;
	}


	private void getDictString(StringBuffer result, Object value, String itemKey, String[] fieldKeyList) throws Throwable {
		if ( value != null ) {
			//多选处理
			if (value instanceof String[]){
				String[] v = (String[])value;
				for(int i = 0;i<v.length;i++){
					Item item = dictCache.getItem(itemKey, TypeConvertor.toLong(v[i]));
					if ( item != null ) {
						//多选字典按,隔开
						if(result.length()!=0) {
							result.append(",");
						}
						
						if ( fieldKeyList != null ) {
							for (int j = 0, size = fieldKeyList.length; j < size; ++j) {
								String fieldValue = TypeConvertor.toString(item.getValue(fieldKeyList[j]));
								if (result.length()==0) {
									result.append(fieldValue);
								} else {
									result.append(" ").append(fieldValue);
								}
							}
						} else {
							result.append(item.getValue("Code")).append(" ").append(item.getValue("Name"));
						}
					}
				}
			}
			//单选处理
			else{
				Item item = dictCache.getItem(itemKey, TypeConvertor.toLong(value));
				if ( item != null ) {
					if ( fieldKeyList != null ) {
						for (int i = 0, size = fieldKeyList.length; i < size; ++i) {
							String fieldValue = TypeConvertor.toString(item.getValue(fieldKeyList[i]));
							if (result.length()==0) {
								result.append(fieldValue);
							} else {
								result.append(" ").append(fieldValue);
							}
						}
					} else {
						result.append(item.getValue("Code")).append(" ").append(item.getValue("Name"));
					}
				}
			}
		}
	}
}
