package com.bokesoft.yes.excel.template;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelFormat;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelListItem;

public class ExcelFormat {
	/** 自定义数据类型*/
	private int dataType = ExcelFormatDataType.Text;
	/** 字典标识 */
	private String itemKey = "";
	/** 字段列表 */
	private String fieldKeys = "";
	/** 格式化字符串*/
	private String formatString = "";
	
	private String[] fieldKeysList = null;
	
	private List<ExcelListItem> listItems = null;
	
	private ExcelFormat() {}
	
	public ExcelFormat(MetaExcelFormat format) {
		this.dataType = format.getDataType();
		this.itemKey = format.getItemKey();
		this.formatString = format.getFormatString();
		
		setFieldKeys(format.getFieldKeys());
		List<MetaExcelListItem> metaListItem = format.getListItems();
		if (metaListItem != null && metaListItem.size() > 0) {
			listItems = new ArrayList<ExcelListItem>();
			for (MetaExcelListItem metaItem : metaListItem) {
				listItems.add(new ExcelListItem(metaItem.getValue(), metaItem.getText()));
			}
		}
	}
	
	/**
	 * 设置字典项标识
	 * @param itemKey 字典项标识
	 */
	public void setItemKey(String itemKey) {
		this.itemKey = itemKey;
	}
	
	/**
	 * 取得字典项标识
	 * @return 字典项标识
	 */
	public String getItemKey() {
		return this.itemKey;
	}
	
	/**
	 * 设置字段列表
	 * @param fieldKeys 字段列表
	 */
	public void setFieldKeys(String fieldKeys) {
		this.fieldKeys = fieldKeys;
		if ( fieldKeys != null && !fieldKeys.isEmpty() ) {
			fieldKeysList = fieldKeys.split(",");
		}
	}
	
	/**
	 * 设置字段列表
	 * @return 字段列表
	 */
	public String getFieldKeys() {
		return this.fieldKeys;
	}
	
	/**
	 * 取得字段列表数组
	 * @return 字段列表数组
	 */
	public String[] getFieldKeyList() {
		return this.fieldKeysList;
	}
	
	/**
	 * 设置下拉列表项
	 * @param listItems
	 */
	public void setListItems(List<ExcelListItem> listItems) {
		this.listItems = listItems;
	}
	
	/**
	 * 获取下拉列表
	 * @return
	 */
	public List<ExcelListItem> getListItems() {
		return this.listItems;
	}
	
	public int getDataType() {
		return dataType;
	}

	public void setDataType(int dataType) {
		this.dataType = dataType;
	}

	public String getFormatString() {
		return formatString;
	}

	public void setFormatString(String formatString) {
		this.formatString = formatString;
	}

	public ExcelFormat clone() {
		ExcelFormat newObject = new ExcelFormat();
		newObject.setDataType(dataType);
		newObject.setItemKey(itemKey);
		newObject.setFieldKeys(fieldKeys);
		newObject.setFormatString(formatString);
		newObject.setListItems(listItems);
		return newObject;
	}
}
