package com.bokesoft.yes.excel.service;

import java.util.HashMap;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.excel.cmd.dee.DescribeCmd;
import com.bokesoft.yes.excel.cmd.dee.ImportDEEDataCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class DEEService extends GeneralService<DefaultContext> {
	@Override
	public String getServiceName() {
		return "DEE";
	}
	
	@Override
	protected Object[][] getCmdImplTable() {
		return new Object[][] {
				{ "Import", new ImportDEEDataCmd() },
				{ "describe", new DescribeCmd()}
		};
	}
	@Override
	public void checkSecurity(DefaultContext context, String cmd, StringHashMap<Object> arguments) throws Throwable {
		return ;
	}
	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		return new ImportDEEDataCmd();
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		return (IServiceCmd<DefaultContext>)DEEService.prototype.get(cmd);
	}
	
	private static HashMap<String, IServiceCmd<?>> prototype = null;
	static {
		DEEService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(DEEService.prototype, new DEEService());
	}
	
	public IServiceProvider<DefaultContext> newInstance() {
		return new DEEService();
	}

	
	
}
