package com.bokesoft.yes.excel.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Map.Entry;

public class ExcelGroupDataRow implements IExcelDataRow {

	private ArrayList<IExcelDataRow> detailRows = new ArrayList<IExcelDataRow>();
	
	private TreeMap<Integer, Object> valueMap = new TreeMap<Integer, Object>();
	
	public ExcelGroupDataRow() {
		
	}
	
	@Override
	public int getRowIndex() {
		return -1;
	}
	
	@Override
	public String getType() {
		return "group";
	}
	
	public void addDetailRow(IExcelDataRow row) {
		detailRows.add(row);
	}
	
	public void addAllValueMap(TreeMap<Integer, Object> valueMap) {
		this.valueMap = valueMap;
	}
	
	public void addValueMap(Integer groupLevel, Object value) {
		if (!valueMap.containsKey(groupLevel)) {
			valueMap.put(groupLevel, value);
		}
	}
	
	public TreeMap<Integer, Object> getValueMap(){
		return valueMap;
	}
	
	public Iterator<Entry<Integer, Object>> valueMapIterator(){
		return valueMap.entrySet().iterator();
	}
	
	public Iterator<IExcelDataRow> iterator() {
		return detailRows.iterator(); 
	}
	
	public IExcelDataRow getRow(int index) {
		return detailRows.get(index);
	}
	
	public int size() {
		return detailRows.size();
	}
	
	public ArrayList<IExcelDataRow> getDetailRows(){
		return detailRows;
	}
}
