package com.bokesoft.yes.excel.datatransfer;

import java.util.Date;
import java.util.Iterator;

import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.paratable.MetaParaGroup;
import com.bokesoft.yigo.meta.paratable.MetaParaItem;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.dict.Item;
import com.bokesoft.yigo.tools.dict.IDictCache;

public class DataTransferUtil {
	public static Object convertFieldValue(DefaultContext context, MetaForm metaForm, int controlType, AbstractMetaObject properties, DataTable dataTable,
			String columnKey) throws Throwable {
		Object value = dataTable.getObject(columnKey);
		return convertFieldValue(context, metaForm, controlType, properties, dataTable, columnKey, value);
	}
	
	public static Object convertFieldValue(DefaultContext context, MetaForm metaForm, int controlType, AbstractMetaObject properties, DataTable dataTable,
			String columnKey, Object value) throws Throwable {
		
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		Object retValue = value;
		switch (controlType) {
		case ControlType.DICT:
			MetaDictProperties dp = (MetaDictProperties)properties;
			retValue = getDictCaption(dp, context, dp.getItemKey(), value);
			break;
		case ControlType.DYNAMICDICT:
		case ControlType.COMPDICT:
			MetaDictProperties _dp = (MetaDictProperties)properties;
			String itemKey = dataTable.getString(columnKey + "itemkey");
			retValue = getDictCaption(_dp, context, itemKey, value);
			break;
		case ControlType.DATEPICKER:
			MetaDatePickerProperties dateProperties = (MetaDatePickerProperties) properties;
			boolean onlyDate = dateProperties.isOnlyDate();
			String format = onlyDate ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";

			Date date = TypeConvertor.toDate(value);
			if (date != null) {
				retValue = DateUtil.getDateFormatText(date, format);
			}
			break;
		case ControlType.CHECKLISTBOX:
			MetaCheckListBoxProperties checkListBoxProperties = (MetaCheckListBoxProperties)properties;
			int Type = checkListBoxProperties.getSourceType();
			switch (Type) {
			case ComboBoxSourceType.ITEMS:
				MetaDefaultItem item = null;
				MetaListBoxItemCollection it = checkListBoxProperties.getItems();
				String[] s = TypeConvertor.toString(value).split(",");
				if (s.length == 1 && s[0].equals("")){
					retValue = "";
				}else{
					for (int i = 0;i<s.length;i++){
						for(int j = 0; j<it.size();j++){
							if (it.get(j).getValue().equals(s[i])){
								item = it.get(j);
							}
						}
						if (i==0){
							retValue = item.getCaption();
						}else{
							retValue = retValue + "," + item.getCaption();
						}
					}
				}
				break;
			case ComboBoxSourceType.PARAGROUP:
				String groupKey = checkListBoxProperties.getGroupKey();

				MetaParaGroup metaParaGroup = MetaUtil.getParaGroup(metaFactory, groupKey);
				if (metaParaGroup != null) {
					MetaParaItem metaParaItem = null;
					String[] str = TypeConvertor.toString(value).split(",");
					if (str.length == 1 && str[0].equals("")){
						retValue = "";
					}else{
						for (int i = 0;i<str.length;i++){
									for (MetaParaItem paraItem : metaParaGroup) {
										if (paraItem.getValue().equals(str[i])){
											metaParaItem = paraItem;
								}
							}
							if (i == 0){
								retValue = metaParaItem.getCaption();
							}else{
								retValue = retValue + "," + metaParaItem.getCaption();
							}
						}
					}
				}
				break;
			}
			break;
		case ControlType.COMBOBOX:
			MetaComboBoxProperties comboboxProperties = (MetaComboBoxProperties) properties;
			int sourceType = comboboxProperties.getSourceType();
			switch (sourceType) {
			case ComboBoxSourceType.ITEMS:
				MetaDefaultItem item = null;
				Iterator<MetaDefaultItem> it = comboboxProperties.getItems().iterator();
				while (it.hasNext()) {
					item = it.next();
					if (item.getValue().equalsIgnoreCase(TypeConvertor.toString(value))) {
						retValue = item.getCaption();
						break;
					}
				}
				break;
			case ComboBoxSourceType.STATUS:
				MetaStatusCollection statusCollection = MetaUtil.getStatusCollection(metaFactory,metaForm.getDataSource().getDataObject());
				if ( statusCollection != null ) {
					int intValue = TypeConvertor.toInteger(value);
					Iterator<MetaStatus> itStatus = statusCollection.iterator();
					while ( itStatus.hasNext() ) {
						MetaStatus metaStatus = itStatus.next();
						int statusValue = metaStatus.getValue();
						if (intValue == statusValue) {
							retValue = metaStatus.getCaption();
							break;
						}
					}
				}
				break;
			case ComboBoxSourceType.PARAGROUP:
				String groupKey = comboboxProperties.getGroupKey();

				MetaParaGroup metaParaGroup = MetaUtil.getParaGroup(metaFactory, groupKey);
				if (metaParaGroup != null) {
					MetaParaItem metaParaItem = null;
					Iterator<MetaParaItem> paraItemIt = metaParaGroup.iterator();
					while (paraItemIt.hasNext()) {
						metaParaItem = paraItemIt.next();
						if (metaParaItem.getValue().equalsIgnoreCase(TypeConvertor.toString(value))) {
							retValue = metaParaItem.getCaption();
							break;
						}
					}
				}
				break;
			}
			break;
		}

		return retValue;
	}

	private static String getDictCaption(MetaDictProperties dictProperties, DefaultContext context, String itemKey, Object value) throws Throwable {
		String caption = "";
		Item item = null;
		long id = -1;
		IDictCache dictCache = context.getDictCache();
		if( dictProperties.isAllowMultiSelection() ) {
			String strValue = TypeConvertor.toString(value);
			if( strValue != null && !strValue.isEmpty() ) {
				String[] array = strValue.split(",");
				for( int i = 0,size = array.length;i < size;i++ ) {
					id = TypeConvertor.toLong(array[i]);
					item = dictCache.getItem(itemKey, id);
					if( item != null ) {
						caption += "," + item.getCaption();
					}
				}
				if( !caption.isEmpty() ) {
					caption = caption.substring(1);
				}
			}
		} else {
			id = TypeConvertor.toLong(value);
			item = dictCache.getItem(itemKey, id);
			if( item != null ) {
				caption = item.getCaption();
			}			
		}
		return caption;
	}
}
