package com.bokesoft.yes.excel.cmd.stamp.output.strategy;

import org.apache.poi.ss.usermodel.Workbook;

import com.bokesoft.yes.excel.cmd.stamp.output.process.OutputRowProcess;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;
import com.bokesoft.yes.excel.template.style.StampExcelStyleFactory;
import com.bokesoft.yes.excel.template.util.ExcelUtil;

/**
 * 批量导出输出策略
 * 
 * @author chenbb
 *
 */
public class BatchOutputStrategy extends BaseOutputStrategy {
	// 下一个表单的导出起始位置
	private int detailStartRowIndex = ExcelTemplateConstants.BATCH_START_DTL_ROW;
	// 记录当前导出到哪一行
	private int tempRowIndex = 0;
	// 是否为第一个表单
	//private boolean bFirstDoc = true;
	
	public BatchOutputStrategy(Workbook workbook, StampExcelStyleFactory styleFactory, ExcelTemplate excelSheetTemplate) {
		super(workbook, styleFactory, excelSheetTemplate);
	}
	
	@Override
	public void insertRow(int sheetRowIndex, OutputRowProcess exportRowProcess) {
		ExcelUtil.insertRow(curSheet, detailStartRowIndex + sheetRowIndex);
	}
	
	@Override
	public void outputCell(Object value, int rowIndex, int colIndex, ExcelTemplateField field, boolean isDtl) {
		setCellValue(value, detailStartRowIndex + rowIndex, colIndex, field);
		tempRowIndex = Math.max(tempRowIndex, rowIndex);
	};
	
	@Override
	public void postOutputExcel(ExcelTemplate exportSheetProcess) {
		detailStartRowIndex += tempRowIndex + 1;
		tempRowIndex = 0;
	};
}
