package com.bokesoft.yes.excel.cmd.stamp.output.process;

import java.util.LinkedHashMap;
import java.util.Map;

import com.bokesoft.yes.excel.cmd.stamp.output.strategy.IOutputStrategy;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.transformer.ExcelTransformerFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;

public class OutputSheetProcess {
	
	private ExcelTemplateSheet templateSheet = null;
	
	private LinkedHashMap<String, OutputTableProcess> mapTableProcess = null;
	
	private int curSheetRowIndex = 0;
	
	public OutputSheetProcess(ExcelTemplateSheet templateSheet) {
		 this.templateSheet = templateSheet;
		 this.init();
	}
	
	private void init() {
		this.mapTableProcess = new LinkedHashMap<>();
		for (ExcelTemplateTable templateTable : templateSheet.getTemplateTables()) {
			OutputTableProcess tableProcess = new OutputTableProcess(templateTable);
			mapTableProcess.put(tableProcess.getTableKey(), tableProcess);
		}
	}
	public ExcelTemplateSheet getTemplateSheet() {
		return this.templateSheet;
	}
	
	public void setCurSheetRowIndex(int sheetRowIndex) {
		this.curSheetRowIndex = sheetRowIndex;
	}
	
	public int getCurSheetRowIndex() {
		return this.curSheetRowIndex;
	}
	
	public void doProcess(Document doc, Object linkedDetailValue, ExcelTransformerFactory transformerFactory,
			DefaultContext context, IOutputStrategy action, boolean isNeedResetCellIndex) throws Throwable {
		OutputRowProcess exportRowProcess = new OutputRowProcess();
		exportRowProcess.setLinkedDetailValue(linkedDetailValue);
		OutputTableProcess exportTableProcess = null;
		for (Map.Entry<String, OutputTableProcess> entry : mapTableProcess.entrySet()) {
			DataTable dataTable = doc.get(entry.getKey());
			exportTableProcess = entry.getValue();
			ExcelTemplateTable templateTable = exportTableProcess.getTemplateTable();
			exportRowProcess.setTemplateTable(templateTable);
			exportTableProcess.setExportRowProcess(exportRowProcess);
			action.preOutputTable(exportTableProcess);
			exportTableProcess.export(dataTable, transformerFactory, context, action, isNeedResetCellIndex);
			action.postOutputTable(exportTableProcess);
		}
	}
}
