package com.bokesoft.yes.excel.cmd.stamp.input.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.InTable4Normal;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;

public class NormalBatchInputStrategy implements IInputStrategy {
	
	private ExcelTemplate excelTemplate = null;
	
	private List<IInDocument<IInTable>> listInDocument = null;
	
	private IInputReaderBag workbookReader = null;
	
	private ExcelProcessContext excelProcessContext = null;
	
	public NormalBatchInputStrategy(ExcelTemplate excelTemplate, IInputReaderBag workbookReader, ExcelProcessContext excelProcessContext) {
		this.excelTemplate = excelTemplate;
		this.workbookReader = workbookReader;
		this.excelProcessContext = excelProcessContext;
		this.listInDocument = new ArrayList<>();
		this.init();
	}
	
	private void init() {
		ExcelTemplateField firstField = null;
		ExcelTemplateTable firstTable = null;
		for (ExcelTemplateTable tableTemplate : excelTemplate.getTemplateTables4StampImport()) {
			if (firstField == null) {
				firstTable = tableTemplate;
				firstField = tableTemplate.getTemplateField(0);
			}
		}

		int beginRowIndex = 0;
		int startRow = firstTable.getStartDtlRowIndex() + ExcelTemplateConstants.ROW_STEP_NEXT;
		String sheetName = firstTable.getSheetName();
		Object tmpPrimaryValue = null, curPrimaryValue = null;
		int maxRowNum = workbookReader.getLastRowNum(sheetName) + 1; //多算一行，否则最后一个导入对象可能无法结尾
		for (int row = startRow; row <= maxRowNum; row ++) {
			tmpPrimaryValue = workbookReader.getValue(sheetName, row, firstField.getColIndex(), excelProcessContext);
			if (StringUtil.isBlankOrNull(tmpPrimaryValue) && StringUtil.isBlankOrNull(curPrimaryValue)) {
				continue;
			}
			if (!StringUtil.isBlankOrNull(tmpPrimaryValue) && curPrimaryValue == null) {
				beginRowIndex = row;
				curPrimaryValue = tmpPrimaryValue;
			} else if (workbookReader.isEmptySheetRow(sheetName, row) ||
					(!StringUtil.isBlankOrNull(tmpPrimaryValue) && !tmpPrimaryValue.equals(curPrimaryValue))) {
				// 遇到空行，或 关键值不为空且与当前值不一致时创建数据对象
				InDocument<IInTable> inDoc = new InDocument<>(curPrimaryValue, workbookReader);
				for (ExcelTemplateTable tableTemplate : excelTemplate.getTemplateTables4StampImport()) {
					InTable4Normal inTable = new InTable4Normal(tableTemplate, beginRowIndex, row - 1, workbookReader);
					inDoc.addTable(inTable);
				}
				listInDocument.add(inDoc);
				beginRowIndex = row;
				curPrimaryValue = tmpPrimaryValue;
			}
		}
	}
	
	@Override
	public Iterator<IInDocument<IInTable>> iterator() {
		return new InDocumentListIterator(this.listInDocument);
	}

}
