package com.bokesoft.yes.excel.cmd.stamp.input.strategy;

import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.template.ExcelTemplate;

public class InputStrategyFactory {
	
	public static IInputStrategy create(ExcelTemplate excelTemplate, IInputReaderBag workbookReader, ExcelProcessContext excelProcessContext) throws Throwable {
		switch (excelTemplate.getType()) {
		case Single:
			return new SingleInputStrategy(excelTemplate, workbookReader, excelProcessContext);
		case Batch:
			return new NormalBatchInputStrategy(excelTemplate, workbookReader, excelProcessContext);
		case MultiBatch:
			return new MultiBatchInputStrategy(excelTemplate, workbookReader, excelProcessContext);
		default:
			return new SingleInputStrategy(excelTemplate, workbookReader, excelProcessContext);
		}
		
	}

}
