package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct;

import java.util.HashMap;

/**
 * sheet中的图片所在行管理
 * 
 * @author chenbb
 *
 */
public class PictureRow {
	
	private HashMap<Integer, PictureCell> mapCells = null;
	
	public PictureRow() {
		this.mapCells = new HashMap<>();
	}
	
	public PictureCell getPictureCell(int col) {
		return this.mapCells.get(col);
	}
	
	public PictureCell ensurePictureCell(int colIndex) {
		PictureCell cell = mapCells.get(colIndex);
		if (cell == null) {
			cell = new PictureCell();
			mapCells.put(colIndex, cell);
		}
		return cell;
	}
}
