package com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.builder;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;

import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.item.NormalPictureItem;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct.PictureSheet;

public class XSSFPictureSheetBuilder extends AbstractPictureSheetBuilder {
	
	@Override
	public PictureSheet build(Object oSheet) {
		XSSFSheet sheet = (XSSFSheet) oSheet;
		List<POIXMLDocumentPart> relations = sheet.getRelations();
		if (!CollectionUtils.isEmpty(relations)) {
			for (int i = 0; i < relations.size(); i++) {
				POIXMLDocumentPart part = relations.get(i);
				if (part instanceof XSSFDrawing) {
					XSSFDrawing drawing = (XSSFDrawing) part;
					List<XSSFShape> shapes = drawing.getShapes();
					if (!CollectionUtils.isEmpty(shapes)) {
						for(int j = 0;j<shapes.size();j++) {
							XSSFShape shape = shapes.get(j);
							XSSFPicture picture = (XSSFPicture) shape;
							XSSFPictureData pdata = picture.getPictureData();
							XSSFClientAnchor anchor = picture.getPreferredSize();
							short col1 = anchor.getCol1();
							int row1 = anchor.getRow1();
							addPictureItem(row1, col1, new NormalPictureItem(pdata));
						}
					}
				}
			}
		}
	
		return this.pictureSheet;
	}
	
}
