package com.bokesoft.yes.excel.cmd.stamp.input.reader;

import java.util.ArrayList;

import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

import com.bokesoft.yes.common.storage.IStorageService;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.item.IPictureDataItem;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct.PictureCell;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.struct.PictureSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateSheet;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;

public class SheetReader implements IInputReader {
	
	private Sheet sheet = null;
	
	private ExcelTemplateSheet templateSheet;
	
	private PictureSheet pictureSheet = null;

	public SheetReader(Sheet sheet, ExcelTemplateSheet templateSheet) {
		this.sheet = sheet;
		this.templateSheet = templateSheet;
	}

	@Override
	public Object getValue(int row, int col, ExcelProcessContext context) {
		Object value = ExcelUtil.getCellValue(sheet, row, col);
		if (context == null) return value;
		ExcelTemplateField curTemplateField = context.getCurTemplateField();
		if (curTemplateField == null) return value;

		if (curTemplateField.getDataType() == ExcelFormatDataType.Image ||
				curTemplateField.getDataType() == ExcelFormatDataType.ImageList) {
			String picPath;
			try {
				picPath = getPictureValue(row, col, curTemplateField.getStorageService(), context);
				if (!StringUtil.isBlankOrNull(picPath)) {
					value = picPath;
				}
			} catch (Throwable e) {
				e.printStackTrace();
			}

		}
		return value;
	}
	
	private String getPictureValue(int row, int col, String storageClassName, ExcelProcessContext context) throws Throwable {
		if (pictureSheet == null) {
			pictureSheet = context.getPictureSheetBuilder().build(this.sheet);
		}
		if (pictureSheet.existPicture(row, col)) {
			IStorageService storage = context.getStorage(storageClassName);
			PictureCell pictureCell = pictureSheet.getPictureCell(row, col);
			ArrayList<IPictureDataItem> listItems = pictureCell.getPictureItems();
			if (listItems != null) {
				for(IPictureDataItem item: listItems) {
					String path = storage.save(item.getData(), item.getSuggestFileExtension(), context);
					item.setPath(path);
				}
			}
			return pictureCell.getPaths();
		}
		return "";
	}
	
	@Override
	public boolean isEmptyTableRow(String tableKey, int row) {
		Object value = null;
		ExcelTemplateTable tempalteTable = templateSheet.getTemplateTable(tableKey);
		for (ExcelTemplateField field : tempalteTable.getFields()) {
			value = ExcelUtil.getCellValue(sheet, row, field.getColIndex());
			if (!StringUtil.isBlankOrNull(value)) {
				return false;
			}
		}
		return true;
	}

	@Override
	public boolean isEmptySheetRow(int rowIndex) {
		Row row = sheet.getRow(rowIndex);
		if (row == null) {
			return true;
		}
		Object result = null;
		int lastColNum = row.getLastCellNum();
		for (int col = 0; col <= lastColNum; col++) {
			result = ExcelUtil.getCellValue(sheet, rowIndex, col);
			if (!StringUtil.isBlankOrNull(result)) return false;
		}
		return true;
	}

	@Override
	public int getLastRowNum() {
		return sheet.getLastRowNum();
	}
	
	@Override
	public int getLastCellNum(int rowIndex) {
		Row row = sheet.getRow(rowIndex);
		if (row == null) {
			return 0;
		}
		return row.getLastCellNum();
	}

}
