package com.bokesoft.yes.excel.cmd.stamp.input.process.action;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutTable;
import com.bokesoft.yes.excel.template.ExcelTemplateField;
import com.bokesoft.yes.excel.template.ExcelTemplateTable;
import com.bokesoft.yes.excel.template.util.ExcelTemplateUtils;
import com.bokesoft.yigo.common.util.SimpleStringFormat;

public class InputRowCheckAction implements IInputRowAction {

	@Override
	public void doAction(int row, IInTable inTable, OutTable outTable, ExcelTemplateTable templateTable, ExcelProcessContext context) throws Throwable {
		if (templateTable.isDtlTable() && inTable.isEmptySheetRow(templateTable.getSheetName(), row)) {
			return;
		}

		if (inTable.isEmptyTableRow(templateTable.getSheetName(), templateTable.getTableKey(), row)) {
			return;
		}
		
		for (ExcelTemplateField templateField : templateTable.getFields()) {
			String sCheckRule = templateField.getCheckRule();
			if (!templateField.isIgnore4Import() && !StringUtil.isBlankOrNull(sCheckRule) ) {
				List<String> keys = SimpleStringFormat.extrace(sCheckRule);
				String[] arrKeys = new String[keys.size()];
				Object[] arrValues = new Object[keys.size()];
				for (int n = 0; n<keys.size(); n++) {
					ExcelTemplateField field = templateTable.getField(keys.get(n));
					if (field != null) {
						arrKeys[n] = keys.get(n);
						arrValues[n] = inTable.getValue(row, field.getColIndex(), context);
					}
				}
				String checkString = SimpleStringFormat.format_v2(sCheckRule, arrKeys, arrValues);
				boolean bCheck = context.check(checkString);
				if (!bCheck) {
					StringBuilder sb = new StringBuilder();
					String sExcelPosition = ExcelTemplateUtils.getExcelCellKey(row + 1, templateField.getColIndex() + 1);
					sb.append(templateField.getSheetName()).append("!").append(sExcelPosition).append("; ").append(sCheckRule);		
					//sb.append(templateField.getSheetName()).append(" row:").append(row + 1).append(" col:").append(templateField.getColIndex()).append("; rule:").append(sCheckRule);
					
					ArrayList<String> repeatCheck = new ArrayList<String>();
					for (int n=0; n<arrKeys.length; n++) {
						if (!repeatCheck.contains(arrKeys[n])) {
							sb.append("; ").append(arrKeys[n]).append("=").append(arrValues[n]);
							repeatCheck.add(arrKeys[n]);
						}
					}
					context.recordError(sb);
				}
			}
		}
	}
}