package com.bokesoft.yes.excel.cmd.stamp.dependency;

import java.util.ArrayList;
import java.util.List;

public class ExpFieldItem {
	
	public final static String SP = ".";
	
	private String key = null;
	
	private String fieldKey = null;
	
	private String tableKey = null;
	
	private String formula = null;
	
	private boolean isHead = false;
	
	private List<ExpFieldItem> dependencies = null;
	
	public ExpFieldItem(String fieldKey, String tableKey, String formula, boolean isHead) {
		this.fieldKey = fieldKey;
		this.tableKey = tableKey;
		this.formula = formula;
		this.isHead = isHead;
		this.key = createKey(this.fieldKey, this.tableKey);
		this.dependencies = new ArrayList<>();
	}
	
	public String getKey() {
		return this.key;
	}
	
	public String getFieldKey() {
		return this.fieldKey;
	}
	
	public String getTableKey() {
		return this.tableKey;
	}
	
	public String getFormula() {
		return this.formula;
	}
	
	public void addDependency(ExpFieldItem dep) {
		dependencies.add(dep);
	}
	
	public List<ExpFieldItem> getDependencies() {
		return dependencies;
	}
	
	public boolean hasDependency() {
		return this.dependencies.size() > 0;
	}
	
	public boolean isHead() {
		return this.isHead;
	}
	
	public static String createKey(String fieldKey, String tableKey) {
		return tableKey + SP + fieldKey;
	}
	
	public static ExpFieldItem create(String fieldKey, String tableKey, String formula, boolean isHead) {
		return new ExpFieldItem(fieldKey, tableKey, formula, isHead);
	}
}
