package com.bokesoft.yes.excel.cmd.stamp;

import java.util.Iterator;

import org.apache.poi.ss.usermodel.Workbook;
import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.excel.cmd.normal.IImport;
import com.bokesoft.yes.excel.cmd.stamp.base.ExcelProcessContext;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.in.IInTable;
import com.bokesoft.yes.excel.cmd.stamp.input.doc.out.OutDocument;
import com.bokesoft.yes.excel.cmd.stamp.input.process.InputDocumentProcess;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.IInputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.InputRowAction;
import com.bokesoft.yes.excel.cmd.stamp.input.process.action.InputRowCheckAction;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.IInputReaderBag;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.WorkbookReader;
import com.bokesoft.yes.excel.cmd.stamp.input.reader.picture.PictureSheetBuilderFactory;
import com.bokesoft.yes.excel.cmd.stamp.input.strategy.IInputStrategy;
import com.bokesoft.yes.excel.cmd.stamp.input.strategy.InputStrategyFactory;
import com.bokesoft.yes.excel.template.ExcelTemplate;
import com.bokesoft.yes.excel.template.builder.SheetTemplateBuilder;
import com.bokesoft.yes.excel.template.constants.ExcelTemplateConstants;
import com.bokesoft.yes.parser.LexDef;
import com.bokesoft.yes.parser.Lexer;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.document.SaveData;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;
import com.bokesoft.yigo.util.ExcelUtils;

public class ImportExcelWithStamp implements IImport {

	private Workbook workbook = null;
	// 上下文关系
	private DefaultContext context = null;
	// 保存前处理事件
	private String postServiceName = null;
	
	private Document curDocument = null;

	public ImportExcelWithStamp(DefaultContext context, Workbook workbook, Document document, String postServiceName) throws Throwable {
		this.context = context;
		this.workbook = workbook;
		this.curDocument = document;
		this.postServiceName = postServiceName;
	}

	public Object importData() throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		SheetTemplateBuilder templateBuilder = new SheetTemplateBuilder("", workbook, metaFactory);
		ExcelTemplate excelTemplate = templateBuilder.create();
	
		
		MetaForm metaForm = metaFactory.getMetaForm(excelTemplate.getFormKey());
		MetaDataObject metaDataObject = MetaUtil.getDataObject(metaFactory, metaForm);
		ExcelProcessContext excelProcessContext = new ExcelProcessContext(excelTemplate.getFormKey(), metaDataObject, context);
		excelProcessContext.setPictureSheetBuilder(PictureSheetBuilderFactory.createPictureSheetBuilder(workbook));
		IInputReaderBag workbookReader = new WorkbookReader(workbook, excelTemplate);
		InputDocumentProcess docProcess = new InputDocumentProcess(excelTemplate);
		
		IInputRowAction checkAction = new InputRowCheckAction();
		IInputStrategy inputStrategy = InputStrategyFactory.create(excelTemplate, workbookReader, excelProcessContext);
		
		// 预检查excel文件
		IInDocument<IInTable> inDoc = null;
		Iterator<IInDocument<IInTable>> iterator = inputStrategy.iterator();
		while (iterator.hasNext()) {
			inDoc = iterator.next();
			docProcess.doProcess(inDoc, null, checkAction, excelProcessContext); 
		}
		
		if (excelProcessContext.hasError()) {
			JSONObject result = new JSONObject();
			result.put(ExcelTemplateConstants.S_CHECKERROR, excelProcessContext.getError());
			return result;
		}
		
		JSONArray failedItems = new JSONArray();
		JSONArray successedItems = new JSONArray();
		IInputRowAction fillValueAction = new InputRowAction();
		iterator = inputStrategy.iterator();
		while (iterator.hasNext()) {
			inDoc = iterator.next();
			try {
				Document document = null;
				if (isImportCurDocument(excelTemplate)) {
					document = curDocument;
				} else {
					document = DocumentUtil.newDocument(metaDataObject);
					document.setNew();
					document.setOID(context.applyNewOID());
				}
				excelProcessContext.setCurDocument(document);
				OutDocument outDoc = new OutDocument(document);
				docProcess.doProcess(inDoc, outDoc, fillValueAction, excelProcessContext); 
				// 对未涉及到导入模板的字段默认值公式进行计算
				ExcelUtils.calcDefaultFormula(document, excelTemplate, context);
				
				DefaultContext newContext = new DefaultContext(context);
				newContext.setFormKey(context.getFormKey());
				doPostProcessService(postServiceName, document, metaDataObject, newContext);
				if (!isImportCurDocument(excelTemplate)) {	
					SaveData saveData = new SaveData(metaDataObject, null, document);
					saveData.save(newContext);
				}
				successedItems.put(inDoc.getPrimaryValue() + "->" + document.getOID());
			} catch (Throwable e) {
				failedItems.put(inDoc.getPrimaryValue() + "->" + e.getMessage());
				e.printStackTrace();
			}
		}
		
		JSONObject result = new JSONObject();
		result.put(ExcelTemplateConstants.S_FAIL, failedItems);
		result.put(ExcelTemplateConstants.S_SUCCESS, successedItems);
		return result;
	}
	
	/**
	 * 是否为导入到当前编辑界面
	 * 
	 * @param excelTemplate
	 * @return
	 */
	private boolean isImportCurDocument(ExcelTemplate excelTemplate) {
		return curDocument != null && excelTemplate.getType() == EExcelTemplateType.Single;
	}
	
	private void doPostProcessService(String postServiceName, Document document, MetaDataObject metaDataObject, DefaultContext context) throws Throwable {
		// 参考SingleImportExcel这么写
		if (postServiceName != null && !postServiceName.isEmpty()) {
			@SuppressWarnings("unchecked")
			IServiceProcess<IServiceContext> process = (IServiceProcess<IServiceContext>) ReflectHelper.newInstance(context.getVE(), postServiceName);
			if (process != null) {
				context.setDocument(document);
				context.setDataObject(metaDataObject);
				process.process(context);
			}
		}
	}
	
/*	public Object doCmd(DefaultContext context) throws Throwable {
		String dataPath = context.getVE().getMetaFactory().getSolution().getDataPath();
		if (dataPath == null || dataPath.equals("")) {
			dataPath = CoreSetting.getInstance().getSolutionPath() + File.separator + "Data";
		}
		String filePath = ""; //dataPath + File.separator + path;
		File file = new File(filePath);
		if (!file.exists() || !file.isFile()) {
			throw new MidCoreException(MidCoreException.FILE_NOT_EXISTS,
					MidCoreException.formatMessage(null, MidCoreException.FILE_NOT_EXISTS,file.getName()));
		} 
		return file;
	}
*/
	
	public static void main(String[] args) {
		//String formula = "getValue('gggg')+getCellValue('cccc')";
		String formula = "zzz+ddd";
		Lexer lex = new Lexer();
		lex.setContent(formula);
		int lexID = lex.next();
		while (lexID != -1) {
			if (lexID == LexDef.ID || lexID == LexDef.CONST) {
				String dep = lex.getLexValue();
				System.out.println(dep);
				//if( dep != null && !dep.equals(target) ) { // 添加非自身影响项
					//node.add(dep);						
				//}
			}
			lexID = lex.next();
		}
	}
}
