package com.bokesoft.yes.excel.cmd.stamp;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.excel.cmd.normal.IExport;
import com.bokesoft.yes.excel.cmd.normal.LoadMultiPageDocument;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.EExcelTemplateType;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.common.util.UIUtil;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.util.DocumentUtil;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class ExportExcelWithStampCmd  extends DefaultServiceCmd {

	private String formKey = null;
	private Document document = null;
	private FilterMap filterMap = null;
	private ConditionParas condParameters = null;
	private String templateKey = null;
	private String postExportServiceName = null;
	private String exportFileName=null;
	private boolean needDownload = false;
	private EExcelTemplateType type = EExcelTemplateType.Single;
	
	private AbstractRuntimeUIConfig runtimeUIConfig;

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		String parameters = TypeConvertor.toString(arguments.get("parameters"));
		if (parameters != null && !parameters.isEmpty()) {
			JSONObject json = new JSONObject(parameters);
			Paras formParameters = new Paras();
			formParameters.fromJSON(json);
			context.setParas(formParameters);
		}
		
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		templateKey = TypeConvertor.toString(arguments.get("templateKey"));
		String sType = TypeConvertor.toString(arguments.get("templateType"));
		if (!StringUtil.isBlankOrNull(sType)) {
			type = EExcelTemplateType.valueOf(sType);
		}
		
		postExportServiceName = TypeConvertor.toString(arguments.get("postExportServiceName"));
		exportFileName=TypeConvertor.toString(arguments.get("exportFileName"));
		needDownload = TypeConvertor.toBoolean(arguments.get("needDownload"));
		
		JSONObject documentObj = new JSONObject(arguments.get("document").toString());
		long oid = TypeConvertor.toLong(arguments.get("OID"));
		
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
		
		filterMap = new FilterMap();
		filterMap.setOID(oid);
		String filterMapJSONStr = arguments.get("filterMap").toString();
		filterMap.fromJSON(new JSONObject(filterMapJSONStr));
		
		// 处理查询条件
		String conditions = arguments.get("condition").toString();
		if ( conditions != null && !conditions.isEmpty() ) {
			condParameters = new ConditionParas();
			condParameters.fromJSON(new JSONObject(conditions));
		}
		
		document = new Document(metaDataObject, oid);
		document.fromJSON(documentObj);
		
		String uiconfig = TypeConvertor.toString(arguments.get("uiconfig"));
		if (StringUtil.isBlankOrNull(templateKey) && !StringUtil.isBlankOrNull(uiconfig) && !"{}".equals(uiconfig)) {
			JSONObject json = new JSONObject(uiconfig);
			runtimeUIConfig = UIUtil.createRuntimeConfig(json);
		}
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		// 循环查看是否有分页需要重新载入
		if (DocumentUtil.isPaginationForm(formKey, context)) {
			LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(new DefaultContext(context),
					filterMap, condParameters);
			document = loadMultiPageDocument.reloadDocument(metaForm);
		} 
		IExport export = new ExportExcelWithStamp(context, templateKey, type,
				metaForm.getKey(), document, runtimeUIConfig, postExportServiceName, exportFileName,needDownload);
		Object retJSONObject = export.exportData();
		return retJSONObject;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ExportExcelWithStampCmd();
	}

	@Override
	public String getCmd() {
		return "ExportExcelWithStamp";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}