package com.bokesoft.yes.excel.cmd.normal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DocumentUtil;

/**
 * 导入单张单据，返回Document 
 *
 */
public class ImportExcelWithFormulaService implements IImportService2 {
	
	private String formKey = null;
	
	private boolean clearOriginalData = false;
	
	private String postServiceName = null;
	
	private Document document = null;
	
	public ImportExcelWithFormulaService() {

	}
	
	@Override
	public Object importData(DefaultContext context, byte[] bytes) throws Throwable {
		document = DocumentUtil.newDocument(formKey,context.getVE().getMetaFactory());
		document.setNew();
		MetaDataObject metaDataObject = document.getMetaDataObject();
		
		InputStream is = new ByteArrayInputStream(bytes);
		Workbook workbook = WorkbookFactory.create(is);
		
		IImport importData = new ImportExcelWithFormula(formKey, context, metaDataObject, workbook, document, clearOriginalData, postServiceName);
		
		return importData.importData();
	}
	
	@Override
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}

	@Override
	public void setClearOriginalData(boolean clearOriginalData) {
		this.clearOriginalData = clearOriginalData;
	}

	@Override
	public void setPostServiceName(String postServiceName) {	
		this.postServiceName = postServiceName;
	}

}
