//package com.bokesoft.yes.excel.cmd.normal;
//
//import java.util.ArrayList;
//import java.util.HashMap;
//import java.util.Iterator;
//
//import org.apache.poi.ss.usermodel.Cell;
//import org.apache.poi.ss.usermodel.Row;
//import org.apache.poi.ss.usermodel.Sheet;
//import org.apache.poi.ss.usermodel.Workbook;
//import org.apache.poi.xssf.streaming.SXSSFWorkbook;
//import org.json.JSONObject;
//
//import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
//import com.bokesoft.yes.excel.utils.ExcelUtil;
//import com.bokesoft.yigo.common.def.ControlType;
//import com.bokesoft.yigo.common.def.DataType;
//import com.bokesoft.yigo.common.def.PageLoadType;
//import com.bokesoft.yigo.common.def.RowType;
//import com.bokesoft.yigo.common.def.TableMode;
//import com.bokesoft.yigo.meta.dataobject.MetaColumn;
//import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
//import com.bokesoft.yigo.meta.dataobject.MetaTable;
//import com.bokesoft.yigo.meta.form.MetaForm;
//import com.bokesoft.yigo.meta.form.component.MetaComponent;
//import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
//import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
//import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
//import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
//import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
//import com.bokesoft.yigo.mid.base.DefaultContext;
//import com.bokesoft.yigo.struct.condition.ConditionParas;
//import com.bokesoft.yigo.struct.datatable.DataTable;
//import com.bokesoft.yigo.struct.document.Document;
//import com.bokesoft.yigo.struct.document.FilterMap;
//
///**
// * Excel无模板导出入口
// *
// */
//public class ExportExcel {
//	/** 上下文环境*/
//	private DefaultContext context = null;
//	/** 要导出的默认的数据集*/
//	private Document document = null;
//	/** 界面配置对象*/
//	private MetaForm metaForm = null;
//	/** 需要导出的数据源表*/
//	private String exportTable = null;
//	/** 需要重新载入数据的OID过滤*/
//	private FilterMap filterMap = null;
//	/** 需要重新载入数据的条件过滤*/
//	private ConditionParas condParameters = null;
//	/** 是否止导出当前页*/
//	private boolean onlyCurrentPage = false;
//	/** 导出后的扩展服务名*/
//	private String postExportServerName = null;
//
//	/**
//	 * 
//	 * @param context 上下文环境
//	 * @param document 要导出的默认的数据集
//	 * @param filterMap 需要重新载入数据的OID过滤
//	 * @param condParameters 需要重新载入数据的条件过滤
//	 * @param metaForm 界面配置对象
//	 * @param exportTable 需要导出的数据源表,默认全部
//	 */
//	public ExportExcel(DefaultContext context, Document document, FilterMap filterMap, ConditionParas condParameters,
//			MetaForm metaForm, String exportTable, boolean onlyCurrentPage, String postExportServerName) {
//		this.context = context;
//		this.document = document;
//		this.filterMap = filterMap;
//		this.metaForm = metaForm;
//		this.exportTable = exportTable;
//		this.condParameters = condParameters;
//		this.onlyCurrentPage = onlyCurrentPage;
//		this.postExportServerName = postExportServerName;
//	}
//
//	/**
//	 * 导出数据并返回JSONObject对象
//	 * 
//	 * @return JSONObject 
//	 * 返回值属性：
//	 * filePath: 导出文件的后台路径
//	 * formKey:  导出的界面标志
//	 * formCaption: 导出界面的名称
//	 * fileSize: 导出的文件大小
//	 * fileMD5: 导出文件的MD码
//	 */
//	public JSONObject export() throws Throwable {
//		if (document == null) {
//			return null;
//		}
//
//		JSONObject retJSONObject = new JSONObject();
//
//		// 获取MetaDataObject
//		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
//		boolean exportAll = exportTable == null || exportTable.isEmpty();
//		boolean needLoadData = false;
//
//		ArrayList<MetaTable> tableList = new ArrayList<MetaTable>();
//		if (exportAll) {
//			Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
//			while (itTables.hasNext()) {
//				tableList.add(itTables.next());
//			}
//		} else {
//			String[] tableKeys = exportTable.split(",");
//			for (String tableKey : tableKeys) {
//				MetaTable metaTable = metaDataObject.getTable(tableKey);
//				if (metaTable != null) {
//					tableList.add(metaTable);
//				}
//			}
//		}
//
//		if (tableList.size() == 0) {
//			return retJSONObject;
//		}
//
//		MetaTable metaTable = null;
//		DataTable dataTable = null;
//		// 如果是分页表格，数据需要重新载入
//		needLoadData = isNeedLoadData(tableList);
//
//		Document exportDocument = document;
//		try {
//			if (needLoadData && !onlyCurrentPage) {
//				LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(context, filterMap, condParameters);
//				exportDocument = loadMultiPageDocument.reloadDocument(metaForm);
//			}
//
//			// 创建Excel对象 内存中只存1000条记录
//			Workbook workbook = new SXSSFWorkbook(1000);
//
//			// 开始导出
//			Iterator<MetaTable> itTables = tableList.iterator();
//			while (itTables.hasNext()) {
//				metaTable = itTables.next();
//				String tabkeKey = metaTable.getKey();
//				String sheetName = metaTable.getCaption().isEmpty() ? tabkeKey : metaTable.getCaption();
//				dataTable = exportDocument.get(metaTable.getKey());
//				Sheet sheet = ExcelUtil.getSheet(workbook, sheetName);
//
//				exportTable(sheet, metaForm, metaTable, dataTable);
//			}
//
//			ExportExcelUtil.doProcessAfterExport(context, metaForm, retJSONObject, workbook, postExportServerName);
//		} finally {
//			if (needLoadData) {
//				exportDocument.close();
//			}
//		}
//
//		return retJSONObject;
//	}
//
//	private boolean isNeedLoadData(ArrayList<MetaTable> tableList) {
//		MetaTable metaTable = null;
//
//		Iterator<MetaTable> itTables = tableList.iterator();
//		while (itTables.hasNext()) {
//			metaTable = itTables.next();
//			int tableModel = metaTable.getTableMode();
//			switch (tableModel) {
//			case TableMode.DETAIL:
//				MetaComponent metaComponent = metaForm.findComponentByTable(metaTable.getKey());
//				if( metaComponent == null )
//					break;
//				switch (metaComponent.getControlType()) {
//				case ControlType.GRID:
//					MetaGrid metaGrid = (MetaGrid)metaComponent;
//					if( metaGrid.getPageLoadType() == PageLoadType.DB ) {
//						return true;
//					}
//					break;
//				case ControlType.LISTVIEW:
//					MetaListView metaListView = (MetaListView)metaComponent;
//					if( metaListView.getPageLoadType() == PageLoadType.DB ) {
//						return true;
//					}
//					break;
//				}
//			}
//		}
//		return false;
//	}
//
//	private void exportTable(Sheet sheet, MetaForm metaForm, MetaTable metaTable, DataTable dataTable)
//			throws Throwable {
//		int tableModel = metaTable.getTableMode();
//		switch (tableModel) {
//		case TableMode.HEAD:
//			exportHeadTable(sheet, metaForm, metaTable, dataTable);
//			break;
//		case TableMode.DETAIL:
//			exportDetailTable(sheet, metaForm, metaTable, dataTable);
//			break;
//		}
//	}
//
//	private void exportDetailTable(Sheet sheet, MetaForm metaForm, MetaTable metaTable, DataTable dataTable)
//			throws Throwable {
//		String tableKey = metaTable.getKey();
//		DataTable exportTable = dataTable;
//
//		MetaComponent metaComponent = metaForm.findComponentByTable(tableKey);
//		if( metaComponent == null )
//			return;
//		switch (metaComponent.getControlType()) {
//		case ControlType.GRID:
//			exportGridTable(sheet, metaForm, (MetaGrid) metaComponent, metaTable, exportTable);
//			break;
//		case ControlType.LISTVIEW:
//			exportListViewTable(sheet, metaForm, (MetaListView) metaComponent, metaTable, exportTable);
//			break;
//		default:
//			break;
//		}
//	}
//
//	@SuppressWarnings("deprecation")
//	private void exportListViewTable(Sheet sheet, MetaForm metaForm, MetaListView metaListView, MetaTable metaTable,
//			DataTable dataTable) throws Throwable {
//		// 记录ColumnKey和MetaComponent的关系
//		HashMap<String, MetaListViewColumn> map = new HashMap<String, MetaListViewColumn>();
//		// 先找到数据行
//		MetaListViewColumn listViewColumn = null;
//		Iterator<MetaListViewColumn> itListViewColumn = metaListView.getColumnCollection().iterator();
//		while (itListViewColumn.hasNext()) {
//			listViewColumn = itListViewColumn.next();
//			map.put(listViewColumn.getDataColumnKey(), listViewColumn);
//		}
//
//		Cell cell = null;
//		String columnKey = null;
//		MetaListViewColumn metaListViewColumn = null;
//		// 先确定表格标题
//		int colIndex = 0;
//		MetaColumn metaColumn = null;
//		Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
//		Row titileRow = ExcelUtil.getRow(sheet, 0);
//		while (itMetaColumn.hasNext()) {
//			metaColumn = itMetaColumn.next();
//			columnKey = metaColumn.getKey();
//			metaListViewColumn = map.get(columnKey);
//			if (metaListViewColumn != null) {
//				cell = ExcelUtil.getCell(titileRow, colIndex);
//				ExcelUtil.setCellValue(cell, metaListViewColumn.getCaption(), DataType.STRING);
//
//				colIndex++;
//			}
//		}
//
//		// 循环所有数据行、数据列，有字段的才做导出
//		int rowIndex = 1;
//		String value = null;
//		Row dataRow = null;
//		dataTable.beforeFirst();
//		while (dataTable.next(true)) {
//			colIndex = 0;
//			dataRow = ExcelUtil.getRow(sheet, rowIndex);
//			itMetaColumn = metaTable.iterator();
//			while (itMetaColumn.hasNext()) {
//				metaColumn = itMetaColumn.next();
//				columnKey = metaColumn.getKey();
//				metaListViewColumn = map.get(columnKey);
//				if (metaListViewColumn != null) {
//					value = DataTransferUtil.convertFieldValue(context.getVE(), metaForm, metaListViewColumn.getColumnType(),
//							metaListViewColumn.getProperties(), dataTable, columnKey);
//					cell = ExcelUtil.getCell(dataRow, colIndex);
//					ExcelUtil.setCellValue(cell, value, metaColumn.getDataType());
//
//					colIndex++;
//				}
//			}
//
//			rowIndex++;
//		}
//	}
//
//	@SuppressWarnings("deprecation")
//	private void exportGridTable(Sheet sheet, MetaForm metaForm, MetaGrid metaGrid, MetaTable metaTable,
//			DataTable dataTable) throws Throwable {
//		// 记录ColumnKey和MetaComponent的关系
//		HashMap<String, MetaGridCell> map = new HashMap<String, MetaGridCell>();
//		// 先找到数据行
//		Iterator<MetaGridRow> itRow = metaGrid.getRowCollection().iterator();
//		MetaGridRow metaRow = null;
//		MetaGridCell metaCell = null;
//		while (itRow.hasNext()) {
//			metaRow = itRow.next();
//			if (metaRow.getRowType() == RowType.Detail) {
//				Iterator<MetaGridCell> itCell = metaRow.iterator();
//				while (itCell.hasNext()) {
//					metaCell = itCell.next();
//					if (metaTable.getKey().equals(metaCell.getTableKey())) {
//						map.put(metaCell.getColumnKey(), metaCell);
//					}
//				}
//			}
//		}
//
//		Cell cell = null;
//		String columnKey = null;
//		MetaGridCell metaGridCell = null;
//		// 先确定表格标题
//		int colIndex = 0;
//		MetaColumn metaColumn = null;
//		Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
//		Row titileRow = ExcelUtil.getRow(sheet, 0);
//		while (itMetaColumn.hasNext()) {
//			metaColumn = itMetaColumn.next();
//			columnKey = metaColumn.getKey();
//			metaGridCell = map.get(columnKey);
//			if (metaGridCell != null) {
//				cell = ExcelUtil.getCell(titileRow, colIndex);
//				ExcelUtil.setCellValue(cell, metaGridCell.getCaption(), DataType.STRING);
//				colIndex++;
//			}
//		}
//
//		// 循环所有数据行、数据列，有字段的才做导出
//		String value = null;
//		int rowIndex = 1;
//		Row dataRow = null;
//		dataTable.beforeFirst();
//		while (dataTable.next(true)) {
//			colIndex = 0;
//			dataRow = ExcelUtil.getRow(sheet, rowIndex);
//			itMetaColumn = metaTable.iterator();
//			while (itMetaColumn.hasNext()) {
//				metaColumn = itMetaColumn.next();
//				columnKey = metaColumn.getKey();
//				metaGridCell = map.get(columnKey);
//				if (metaGridCell != null) {
//					value = DataTransferUtil.convertFieldValue(context.getVE(), metaForm, metaGridCell.getCellType(),
//							metaGridCell.getProperties(), dataTable, columnKey);
//
//					cell = ExcelUtil.getCell(dataRow, colIndex);
//					ExcelUtil.setCellValue(cell, value, metaColumn.getDataType());
//					
//					colIndex++;
//				}
//			}
//
//			rowIndex++;
//		}
//	}
//
//	private void exportHeadTable(Sheet sheet, MetaForm metaForm, MetaTable metaTable, DataTable dataTable)
//			throws Throwable {
//		// 记录ColumnKey和MetaComponent的关系
//		HashMap<String, MetaComponent> map = new HashMap<String, MetaComponent>();
//		// 先找到属于这张表的字段
//		MetaComponent metaComponent = null;
//		Iterator<MetaComponent> itComponent = metaForm.getAllComponents().iterator();
//		while (itComponent.hasNext()) {
//			metaComponent = itComponent.next();
//			if (metaTable.getKey().equals(metaComponent.getTableKey())) {
//				map.put(metaComponent.getColumnKey(), metaComponent);
//			}
//		}
//
//		String value = "";
//		MetaColumn metaColumn = null;
//
//		// 循环所有列，有字段的才做导出
//		if (dataTable.first()) {
//			Row titleRow = ExcelUtil.getRow(sheet, 0);
//			Row dateRow = ExcelUtil.getRow(sheet, 1);
//
//			Cell cell = null;
//			int colIndex = 0;
//			Iterator<MetaColumn> itMetaColumn = metaTable.iterator();
//			while (itMetaColumn.hasNext()) {
//				metaColumn = itMetaColumn.next();
//				String columnKey = metaColumn.getKey();
//				metaComponent = map.get(columnKey);
//
//				if (metaComponent != null) {
//					cell = ExcelUtil.getCell(titleRow, colIndex);
//					ExcelUtil.setCellValue(cell, metaColumn.getCaption(), DataType.STRING);
//
//					value = DataTransferUtil.convertFieldValue(context.getVE(), metaForm, metaComponent.getControlType(),
//							metaComponent.getProperties(), dataTable, columnKey);
//					cell = ExcelUtil.getCell(dateRow, colIndex);
//					ExcelUtil.setCellValue(cell, value, metaColumn.getDataType());
//
//					colIndex++;
//				}
//			}
//		}
//	}
//}
