package com.bokesoft.yes.excel.cmd.normal;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.bokesoft.yigo.common.def.OperationState;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.json.JSONObject;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.excel.datatransfer.DataTransferUtil;
import com.bokesoft.yes.excel.template.ExcelCell;
import com.bokesoft.yes.excel.template.ExcelDisplay;
import com.bokesoft.yes.excel.template.ExcelRow;
import com.bokesoft.yes.excel.template.ExcelSheet;
import com.bokesoft.yes.excel.template.ExcelWorkbook;
import com.bokesoft.yes.excel.template.util.ExcelUtil;
import com.bokesoft.yes.excel.transformer.IExcelTransformer;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.dict.DictItemGlobalRightFilterUtil;
import com.bokesoft.yes.mid.rights.IRightsProvider;
import com.bokesoft.yes.mid.rights.OperatorRightsUtil;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.exceltemplate.ExcelFormatDataType;
import com.bokesoft.yigo.meta.exceltemplate.ExcelTemplateRowType;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelWorkbook;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;

public class ExportDictWithTemplate implements IExport{
	private DefaultContext context = null;

	private String itemKey = null;
	// 导出后事件服务名
	private String postExportServiceName;
	// Excel对象
	private Workbook workBook = null;
	//Excel模板配置对象
	private MetaExcelWorkbook metaWorkbook = null;
	// Excel模板处理对象
	private ExcelWorkbook virtualWorkbook = null;
	//自定义导出后的文件名(不包含后缀)
	private String exportFileName=null;	
	
	private boolean needDownload = false;
	
	private ExcelStyleFactory styleFactory = null;
	
	private ExportExcelParas paras = null;
	private MetaForm metaForm = null;
	
	private ArrayList<Map<String, ArrayList<Map<Object, Object>>>> datas = new ArrayList<Map<String, ArrayList<Map<Object, Object>>>>();
	
	public ExportDictWithTemplate(DefaultContext context, MetaExcelWorkbook metaWorkbook,String exportFormKey, String postExportServiceName,String exportFileName,boolean needDownload)
			throws Throwable {
		this.context = context;
		this.metaWorkbook = metaWorkbook;
		this.postExportServiceName = postExportServiceName;
		this.exportFileName=exportFileName;		
		this.needDownload = needDownload;
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		metaForm = metaFactory.getMetaForm(exportFormKey);
		itemKey = metaForm.getDataSource().getDataObject().getKey();
		paras = new ExportExcelParas(context, metaForm);
	}

	@Override
	public FileData exportData() throws Throwable {
		
		ResultSet rs = null;
		PsPara psPara = null;
		ExcelSheet excelSheet = null;
		ExcelRow excelRow = null;
		FileData fileData = new FileData();
		
		Sheet sheet = null;
		
		try {
			String formKey = metaWorkbook.getFormKey();
			MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);
			MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
			IDBManager dbm = context.getDBManager();
			virtualWorkbook = new ExcelWorkbook(metaDataObject, metaWorkbook, context.getMidParser());
			workBook = new SXSSFWorkbook(500);
			
			PrepareSQL prepareSQL = getDictSql(context, itemKey);
			psPara = new PsPara(dbm.preparedQueryStatement(prepareSQL.getSQL()), prepareSQL.getSQL());
			rs = dbm.executeQuery(psPara, new NormalQueryArguments(prepareSQL.getPrepareValues().toArray()));
			while (rs.next()) {
				Long OID = TypeConvertor.toLong(rs.getObject(1));
				prepareSingleData(new DefaultContext(context), OID,metaDataObject);
			}
			
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			Iterator<ExcelSheet> itExeclSheet = virtualWorkbook.iterator();
			while (itExeclSheet.hasNext()) {
				JSONObject rowIndexAndColIndex = new JSONObject();				
				excelSheet = itExeclSheet.next();
				sheet = ExcelUtil.getSheet(workBook, excelSheet.getName());
				int offset = 0;
				Iterator<ExcelRow> itExeclRow = excelSheet.iterator();
				while (itExeclRow.hasNext()) {
					excelRow = itExeclRow.next();
					int rowIndex = excelRow.getRowIndex() + offset - 1;
					Row row = ExcelUtil.getRow(sheet, rowIndex);
					ExcelCell excelCell = null;
					Iterator<ExcelCell> itExeclCell = excelRow.iterator();
					while (itExeclCell.hasNext()) {
						excelCell = itExeclCell.next();
						String sourceType = excelCell.getSourceType();
						int colIndex = excelCell.getCellIndex() - 1;						
						row = ExcelUtil.getRow(sheet, rowIndex);
						Cell cell = ExcelUtil.getCell(row, colIndex);
						fillData(sheet,cell,excelRow,excelCell,sourceType,rowIndexAndColIndex, metaDataObject.getMainTableKey());
					}
				}
			}			
			String filePath = ExcelUtils.getExportFilePath(metaFactory, metaForm.getKey());
			
			if (!needDownload){				
				fileData = ExcelFileUtil.writeExcel(workBook, filePath);
			}else{
				fileData = ExcelFileUtil.convertWorkbookToFileData(metaForm.getKey(), exportFileName, workBook);
			}
			IExportPostProcess process = ExcelUtils.getPostExtProcess(context, postExportServiceName);
			if( process != null ) {
				process.process(context, fileData);
			}
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (psPara != null) {
				psPara.close();
			}
		}
		if(needDownload){
			return fileData;
		}else{
			return new FileData();
		}
	}

	private void fillData(Sheet sheet, Cell cell, ExcelRow excelRow, ExcelCell excelCell,String sourceType,JSONObject rowIndexAndColIndex , String mainTableKey) {
		int rowIndex = cell.getRowIndex();
		int colIndex = cell.getColumnIndex();
		ExcelDisplay display = excelCell.getDisplay();
		IExcelTransformer transformer = null;
		boolean wrapText = false;
		int dataType = ExcelFormatDataType.Text;
		if(display != null && display.getFormat()!=null){
			dataType = display.getFormat().getDataType();
		}
		
		styleFactory = new ExcelStyleFactory(workBook);
		
		//获取上一次有相同列时对应行数据写到了的rowIndex
		Iterator<String> it = rowIndexAndColIndex.keys();
		while (it.hasNext()){
			String keyColIndex = it.next();
			if (colIndex == TypeConvertor.toInteger(keyColIndex)){
				rowIndex = rowIndexAndColIndex.getInt(keyColIndex);
			}
		}
		cell.setCellStyle(styleFactory.getCellStyle(excelCell));
		if (sourceType.equalsIgnoreCase("const")){
			ExcelUtil.setCellValue(sheet, rowIndex, colIndex, excelCell.getDefinition());
			rowIndex++;
		}else if (sourceType.equalsIgnoreCase("field")) {	
			
			int rowType = excelRow.getType();
			String rowTableKey = excelRow.getTableKey();
			String cellTableKey = excelCell.getTableKey();
			
			for (int i = 0; i < datas.size(); i++) {
				Map<String, ArrayList<Map<Object, Object>>> data = datas.get(i);
				String tableKey = this.getTableKey(rowType, rowTableKey, cellTableKey);
				
				ArrayList<Map<Object, Object>> table = data.get(tableKey);
				if(table == null){
					continue;
				}
				for (int j = 0; j < table.size(); j++) {
					Map<Object, Object> rowData = null;
					if(rowType == ExcelTemplateRowType.Detail && cellTableKey.equals(mainTableKey)){
						ArrayList<Map<Object, Object>> headTable = data.get(cellTableKey);
						rowData = headTable.get(0);
					}else{
						rowData = table.get(j);
					}
					Object value = (Object)rowData.get(excelCell.getDefinition());
					
					if (dataType == ExcelFormatDataType.Number){
						value = new BigDecimal(value.toString());
					}
					ExcelUtil.setCellValue(sheet, rowIndex, colIndex, value);
					rowIndex++;
					//来源于数据时单元格格式均与模板设置单元格格式相同
					ExcelUtil.getCell(sheet, rowIndex, colIndex).setCellStyle(styleFactory.getCellStyle(excelCell));
				}
			}
		}
		
		if (display != null){
			wrapText = display.isWrapText();
		}
		if (wrapText){
			styleFactory.getCellStyle(excelCell).setWrapText(wrapText);
		}

		//记录本次在某一列时数据记录到了相应的rowIndex数值，再下一次写入该列数据时获取对应的rowIndex。
		rowIndexAndColIndex.put(TypeConvertor.toString(colIndex), TypeConvertor.toString(rowIndex));
	}
	
	private String getTableKey (int rowType, String rowTableKey, String cellTableKey){
		if(rowType == ExcelTemplateRowType.Detail){
			return rowTableKey;
		}
		if(cellTableKey!= null && !cellTableKey.isEmpty()){
			return cellTableKey;
		}
		return  rowTableKey;
	}
	

	
	private Font createDefaultFont(Workbook workbook) {
		Font font = workbook.createFont();
		font.setBold(false);
		font.setItalic(false);
		font.setFontName("宋体");
		font.setFontHeightInPoints((short) 12);
		return font;
	}
	

	private PrepareSQL getDictSql(DefaultContext context, String itemKey) throws Throwable {
		VE ve = context.getVE();
		IMetaFactory metaFactory = ve.getMetaFactory();
		MetaDataObject dataObject = metaFactory.getDataObject(itemKey);
		MetaTable mainTable = dataObject.getMainTable();
		String OID = mainTable.getOIDColumn().getBindingDBColumnName();

		StringBuffer sb = new StringBuffer();
		sb.append("select ");
		sb.append(OID);
		sb.append(" from ");
		sb.append(mainTable.getBindingDBTableName());
		
		List<Object> values = new ArrayList<Object>();
		PrepareSQL dictAuthoritySql = AuthorityCheckUtil.dictAuthoritySql(context, itemKey,OID, OperationState.Default, "", "");
		if (dictAuthoritySql!= null && !StringUtil.isBlankOrNull(dictAuthoritySql.getSQL())) {
			sb.append(" where " + dictAuthoritySql.getSQL());
			values.addAll(dictAuthoritySql.getPrepareValues());
		}
		
//		StringBuilder globalRightFilterResult = new StringBuilder(1024);
//		DictItemGlobalRightFilterUtil.createGlobalRightFilter(context, itemKey, globalRightFilterResult, "", OID);
//		if (0 != sb.length() && !globalRightFilterResult.toString().isEmpty()) {//避免出现这种错误语句：SELECT colum1 FROM table1 WHERE ORDER BY column2
//			sb.append(DBUtil.containWhere(sb.toString()) ? " and " : " where ")
//					.append(globalRightFilterResult.toString());
//		}

		String orderBy = getOrderBySQL(mainTable);
		sb.append(" order by ");
		sb.append(orderBy);
		
		PrepareSQL prepareSQL = new PrepareSQL();
		prepareSQL.setSQL(sb.toString());
		prepareSQL.addAllValue(values);

		return prepareSQL;
	}
	
	private String getOrderBySQL(MetaTable metaTable) {
		StringBuffer sb = new StringBuffer();
		for (MetaColumn metaColumn : metaTable) {
			int sort = metaColumn.getSort();
			switch (sort) {
			case SortType.Asc:
				sb.append(",");
				sb.append(metaColumn.getBindingDBColumnName());
				break;
			case SortType.Desc:
				sb.append(",");
				sb.append(metaColumn.getBindingDBColumnName());
				sb.append(" Desc");
				break;
			}
		}
		
		if (sb.length() == 0) {
			MetaColumn metaColumn = metaTable.get(SystemField.TLEFT_DICT_KEY);
			sb.append(",");
			sb.append(metaColumn.getBindingDBColumnName());
		}
		
		return sb.toString().substring(1);
	}
	
	
	
	private void prepareSingleData(DefaultContext context, long OID,MetaDataObject metaDataObject) throws Throwable {
		
		FilterMap filterMap = new FilterMap();
		filterMap.setOID(OID);
		LoadMultiPageDocument loadMultiPageDocument = new LoadMultiPageDocument(context, filterMap, null);
		Document exportDocument = loadMultiPageDocument.reloadDocument(metaForm);
		try{
			Map<String, ArrayList<Map<Object, Object>>> dictData = new HashMap<String, ArrayList<Map<Object, Object>>>();
			MetaTable metaTable = null;
			Iterator<MetaTable> itTables = metaDataObject.getTableCollection().iterator();
			while (itTables.hasNext()) {
				metaTable = itTables.next();
				prepareData(context, metaTable, exportDocument, dictData, metaTable.getTableMode());
			}
			this.datas.add(dictData);
		}finally{
			if(exportDocument != null){
				exportDocument.close();
			}
		}

	}
	
	private void prepareData(DefaultContext context, MetaTable metaTable, Document exportDocument, Map<String, ArrayList<Map<Object, Object>>> dictData, int tableMode) throws Throwable {
		String tableKey = metaTable.getKey();
		ArrayList<String> columnList = paras.getColumnListByTableKey(tableKey);

		HashMap<String, ExportComponentInfo> componentInfoMap = paras.getComponentInfoByTableKey(tableKey);
		Object value = null;
		ExportComponentInfo componentInfo = null;
		ArrayList<Map<Object, Object>> table = new ArrayList<Map<Object, Object>>();
		
		DataTable dataTable = exportDocument.get(tableKey);
		dataTable.beforeFirst();
		while(dataTable.next(true)) {
			Iterator<String> it = columnList.iterator();
			Map<Object, Object> rowData= new HashMap<Object, Object>();
			while(it.hasNext()) {
				String columnKey = it.next();
				componentInfo = componentInfoMap.get(columnKey);
				
				if (componentInfo != null) {
					value = DataTransferUtil.convertFieldValue(context, metaForm, componentInfo.getControlType(), componentInfo.getProperties(), dataTable, columnKey);					
				}
				
				rowData.put(columnKey, value);		
			}
			table.add(rowData);
		}
		if (table.size() < 1){
			return;
		}	
		dictData.put(tableKey, table);	
	}
	
}