package com.bokesoft.yes.excel.cmd.normal;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;


import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.csv.cmd.normal.IExportPostProcess;
import com.bokesoft.yes.excel.utils.ExcelFileUtil;
import com.bokesoft.yes.mid.authority.util.AuthorityCheckUtil;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.NormalQueryArguments;
import com.bokesoft.yes.mid.connection.dbmanager.PsPara;
import com.bokesoft.yes.mid.dict.DictItemGlobalRightFilterUtil;
import com.bokesoft.yes.mid.rights.IRightsProvider;
import com.bokesoft.yes.mid.rights.OperatorRightsUtil;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.common.def.OperationState;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.tools.ve.VE;
import com.bokesoft.yigo.util.ExcelUtils;

public class ExportDict implements IExport {
	private DefaultContext context = null;

	private String itemKey = null;
	// 导出后事件服务名
	private String postExportServiceName;
	// 待导出的单据的参数集合
	private ExportExcelParas paras;
	//自定义导出后的文件名(不包含后缀)
	private String exportFileName=null;
	
	private MetaForm metaForm = null;
	
	private boolean needDownload = false;
	
	public ExportDict(DefaultContext context, String exportFormKey, String postExportServiceName,String exportFileName,boolean needDownload)
			throws Throwable {
		this.context = context;
		this.postExportServiceName = postExportServiceName;
		this.exportFileName=exportFileName;
		this.needDownload = needDownload;
		
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		metaForm = metaFactory.getMetaForm(exportFormKey);
		itemKey = metaForm.getDataSource().getDataObject().getKey();
		
		paras = new ExportExcelParas(context, metaForm);
	}

	@Override
	public FileData exportData() throws Throwable {
		
		ResultSet rs = null;
		PsPara psPara = null;
		FileData fileData = new FileData();
		
		try {
			BatchExportTools tools = new BatchExportTools(metaForm, paras);
			tools.exportTitleData();
			
			IDBManager dbm = context.getDBManager();
			PrepareSQL prepareSQL = getDictSql(context, itemKey);

			psPara = new PsPara(dbm.preparedQueryStatement(prepareSQL.getSQL()), prepareSQL.getSQL());
			rs = dbm.executeQuery(psPara, new NormalQueryArguments(prepareSQL.getPrepareValues().toArray()));
			while (rs.next()) {
				Long OID = TypeConvertor.toLong(rs.getObject(1));
				tools.exportSingleData(new DefaultContext(context), OID);
			}
						
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			
			String filePath = ExcelUtils.getExportFilePath(metaFactory, metaForm.getKey());
			
			if (!needDownload){				
				fileData = ExcelFileUtil.writeExcel(tools.getWorkbook(), filePath);
			}else{
				fileData = ExcelFileUtil.convertWorkbookToFileData(metaForm.getKey(), exportFileName, tools.getWorkbook());
			}
			IExportPostProcess process = ExcelUtils.getPostExtProcess(context, postExportServiceName);
			if( process != null ) {
				process.process(context, fileData);
			}
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (psPara != null) {
				psPara.close();
			}
		}
		if(needDownload){
			return fileData;
		}else{
			return new FileData();
		}
	}

	private PrepareSQL getDictSql(DefaultContext context, String itemKey) throws Throwable {
		VE ve = context.getVE();
		IMetaFactory metaFactory = ve.getMetaFactory();
		MetaDataObject dataObject = metaFactory.getDataObject(itemKey);
		MetaTable mainTable = dataObject.getMainTable();
		String OID = mainTable.getOIDColumn().getBindingDBColumnName();

		StringBuffer sb = new StringBuffer();
		sb.append("select ");
		sb.append(OID);
		sb.append(" from ");
		sb.append(mainTable.getBindingDBTableName());
		
		List<Object> values = new ArrayList<Object>();
		PrepareSQL dictAuthoritySql = AuthorityCheckUtil.dictAuthoritySql(context, itemKey, OID, OperationState.Default, "", "");
		if (dictAuthoritySql!= null && !StringUtil.isBlankOrNull(dictAuthoritySql.getSQL())) {
			sb.append(" where " + dictAuthoritySql.getSQL());
			values.addAll(dictAuthoritySql.getPrepareValues());
		}
		
//		StringBuilder globalRightFilterResult = new StringBuilder(1024);
//		DictItemGlobalRightFilterUtil.createGlobalRightFilter(context, itemKey, globalRightFilterResult, "", OID);
//		if (0 != sb.length()&& !globalRightFilterResult.toString().isEmpty()) {//避免出现这种错误语句：SELECT colum1 FROM table1 WHERE ORDER BY column2
//			sb.append(DBUtil.containWhere(sb.toString()) ? " and " : " where ")
//					.append(globalRightFilterResult.toString());
//		}

		String orderBy = getOrderBySQL(mainTable);
		sb.append(" order by ");
		sb.append(orderBy);
		
		PrepareSQL prepareSQL = new PrepareSQL();
		prepareSQL.setSQL(sb.toString());
		prepareSQL.addAllValue(values);

		return prepareSQL;
	}
	
	private String getOrderBySQL(MetaTable metaTable) {
		StringBuffer sb = new StringBuffer();
		for (MetaColumn metaColumn : metaTable) {
			int sort = metaColumn.getSort();
			switch (sort) {
			case SortType.Asc:
				sb.append(",");
				sb.append(metaColumn.getBindingDBColumnName());
				break;
			case SortType.Desc:
				sb.append(",");
				sb.append(metaColumn.getBindingDBColumnName());
				sb.append(" Desc");
				break;
			}
		}
		
		if (sb.length() == 0) {
			MetaColumn metaColumn = metaTable.get(SystemField.TLEFT_DICT_KEY);
			sb.append(",");
			sb.append(metaColumn.getBindingDBColumnName());
		}
		
		return sb.toString().substring(1);
	}
}