package com.bokesoft.yes.excel.cmd.normal;

import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class DefaultImportExcelService implements IImportService2 {
	
	private String formKey = null;
	
	private boolean clearOriginalData = false;
	
	private String postServiceName = null;
	
	private boolean isDocTypeDict = false;
	
	@Override
	public Object importData(DefaultContext context, byte[] bytes) throws Throwable {		
		IImport importData = null;
		ImportUtil importUtil = new ImportUtil(context,bytes);
		importUtil.setFormKey(formKey);
		importUtil.setClearOriginalData(clearOriginalData);
		importUtil.setPostServiceName(postServiceName);
		importUtil.setDocTypeDict(isDocTypeDict);
		importData = (IImport)importUtil.initImport();
		if (importData != null) {
			return importData.importData();
		}
		
		return true;
	}

	@Override
	public void setClearOriginalData(boolean clearOriginalData) {
		this.clearOriginalData = clearOriginalData;
	}
	
	@Override
	public void setPostServiceName(String postServiceName) {
		this.postServiceName = postServiceName;
	}
	
	@Override
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	public void setDocTypeDict(boolean isDocTypeDict){
		this.isDocTypeDict = isDocTypeDict;
	}
}
