/**
 * 
 */
package com.bokesoft.yes.dts.data;

import com.bokesoft.yigo.mid.base.DefaultContext;

/**
 * 调用DTS服务需要实现的接口
 * @author lingc
 *
 */
public interface IDTSDataProvider {

	
	/**
	 * 是否启动流程
	 */
	public static final String META_KEY_START = "mule.adapter.start-workflow";
	
	/**
	 * 工作流的key
	 */
	public static final String META_KEY_WORKFLOWKEY = "mule.adapter.workflow-key";
	
	/**
	 * 表单key
	 */
	public static final String META_KEY_FORMKEY = "mule.adapter.formkey";
	
	/**
	 * 需要返回的字段
	 */
	public static final String META_KEY_RETURN = "mule.adapter.return-fields";

	/**
	 * 主表属性中定义
	 * 对应yes DataObjectKey
	 */
	public static final String META_KEY_THING_NAME = "mule.adapter.thing-name";

	/**
	 * 当计划操作类型为insert时有效，是否根据所给唯一标识检查数据库中该记录是否存在,
	 * 0代表不检查直接插入，1代表需要检查，检查时根据mule.adapter.id-fields 检查
	 */
	public static final String META_KEY_INSERT_CHECK_UNIQUE = 
			"mule.adapter.global.config.insert.check.unique";
	/**
	 * 元数据字段, 当计划操作类型为update时有效，如果所要修改的记录无法找到,0为默认值,代表不忽略(抛出异常)，1代表忽略。
	 */
	public static final String META_KEY_UPDATE_NOTHING_IGNORE =
			"mule.adapter.global.config.update-nothing.ignore";
	/**
	 * 元数据字段, 用于表示数据记录的唯一标识定义, 格式为使用逗号分隔的字段名; 例如 "orderNo, productCode". 头表 明细表都有 修改删除 需要验证
	 */
	public static final String META_KEY_ID_FIELDS = "mule.adapter.id-fields";

	/**
     * 主表属性中定义
	 * 元数据字段, 用于表示该数据是否自动删除未传入的明细记录,其值为明细的数据定义名称,多个使用 "," 分隔，"*" 代表所有 例如
	 * "SYS_OperatorRole, SYS_DataCluster".
	 */
	public static final String META_KEY_DELETE_UNKNOWN_DETAIL = "mule.adapter.auto-delete-unknown-detail";
	
	/**
     * 主表属性中定义
	 * 元数据字段, 用于表示该数据是否自动删除未传入的明细记录,其值为明细的数据定义名称,多个使用 "," 分隔，"*" 代表所有 例如
	 * "SYS_OperatorRole, SYS_DataCluster".
	 */
	public static final String META_KEY_DELETE_ALL_DETAIL = "mule.adapter.delete-all-detail";
	/**
	 * 元数据字段, 用于表示当前数据记录的操作类型(实际操作) 取值"insert update delete insert-or-update"
	 */
	public static final String META_KEY_OP = "mule.adapter.op";
	/**
	 * 元数据字段, 用于表示当前数据记录的操作类型(计划操作, 在 prepare 之后会被修改)
	 */
	public static final String META_KEY_OP_PLAN = "mule.adapter.op-plan";


	/** 保留属性 不做处理 */
	public static final String META_KEY_M_D_MAPPING = "mule.adapter.master-detail.mapping";
	public static final String META_KEY_RETURN_STATUS = "mule.adapter.return.status";
	public static final String META_RECORD_UNIQUE_KEY = "mule.adapter.unique.key";
	public static final String META_GLOBALCONFIG_THINGROWSETS_KEY = 
			"mule.adapter.globalconfig.thingrowsets.key";
	public static final String META_TEMP_DELETE_MASTER_IDS = "mule.adapter.delete.master.field.id-list";
	
	/** 其他属性	**/
	public static final String TABLE_NAME = "mule.data.import.table-name";
	public static final String ROW_NO = "norowno";
	public static final String META_KEY_READ = "read";
	
	public static final String[] keyWords = {
			META_KEY_START,
			META_KEY_WORKFLOWKEY,
			META_KEY_FORMKEY,
			META_KEY_RETURN,
			META_KEY_THING_NAME,
			META_KEY_INSERT_CHECK_UNIQUE,
			META_KEY_UPDATE_NOTHING_IGNORE,
			META_KEY_ID_FIELDS,
			META_KEY_DELETE_UNKNOWN_DETAIL,
			META_KEY_DELETE_ALL_DETAIL,
			META_KEY_M_D_MAPPING,
			META_KEY_OP,
			META_KEY_OP_PLAN,
			META_KEY_RETURN_STATUS,
			META_RECORD_UNIQUE_KEY,
			META_GLOBALCONFIG_THINGROWSETS_KEY,
			META_TEMP_DELETE_MASTER_IDS,	
			TABLE_NAME,
			ROW_NO
	};
	/**
	 * 解析字符串获得调用服务需要的数据的封装类
	 * @param jsonString
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public DTSData getDTSData(String jsonString, DefaultContext context) throws Throwable;
	
	/**
	 * 构造调用服务需要的上下文
	 * @param context
	 * @return
	 * @throws Throwable
	 */
	public DefaultContext getContext(DefaultContext context) throws Throwable;
}
