package com.bokesoft.yes.dts.data;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.bokesoft.yes.dts.types.OperationTypes;
import com.bokesoft.yigo.struct.document.Document;

public class DTSDataBuilder{
	private Document document = null;
	private String dataObjectKey = null;
	private String formKey = null;
	private OperationTypes operation = OperationTypes.DEFAULT;
	private Map<String, List<String>> primaryMap = null;
	private boolean insertCheck = false;
	private boolean updateCheck = false;
	private Set<String> deleteUnknownSet = null;
//	private Set<String> deleteAllSet;
	private List<String> returnFields = null;
	private Map<String, List<OperationTypes>> opMap = null;
	private boolean startInstance = false;
	private String processKey = null;
	public DTSDataBuilder(){
		
	}
	
	public DTSDataBuilder document(Document val){
		this.document = val;
		return this;
	}
	
	public Document getDocument() {
		return this.document;
	}
	
	public DTSDataBuilder dataObjectKey(String val){
		this.dataObjectKey = val;
		return this;
	}
	
	public String getDataObjectKey() {
		return this.dataObjectKey;
	}
	
	public DTSDataBuilder formKey(String val){
		this.formKey = val;
		return this;
	}
	
	public String getFormKey() {
		return this.formKey;
	}
	
	public DTSDataBuilder operation(OperationTypes val){
		this.operation = val;
		return this;
	}
	
	public OperationTypes getOperation() {
		return this.operation;
	}
	
	public DTSDataBuilder primaryMap(Map<String, List<String>> val){
		this.primaryMap = val;
		return this;
	}
	
	public Map<String, List<String>> getPrimaryMap(){
		return this.primaryMap;
	}
	
	public DTSDataBuilder insertCheck(boolean val){
		this.insertCheck = val;
		return this;
	}
	
	public boolean getInsertCheck() {
		return this.insertCheck;
	}
	
	public DTSDataBuilder updateCheck(boolean val){
		this.updateCheck = val;
		return this;
	}
	
	public boolean getUpdateCheck() {
		return this.updateCheck;
	}
	
	public DTSDataBuilder deleteUnknownSet(Set<String> val){
		this.deleteUnknownSet = val;
		return this;
	}
	
	public Set<String> getDeleteUnknownSet(){
		return this.deleteUnknownSet;
	}
	
	public DTSDataBuilder returnFields(List<String> val){
		this.returnFields = val;
		return this;
	}
	
	public List<String> getReturnFields(){
		return this.returnFields;
	}
	
	public DTSDataBuilder opMap(Map<String, List<OperationTypes>> val){
		this.opMap = val;
		return this;
	}
	
	public Map<String, List<OperationTypes>> getOpMap(){
		return this.opMap;
	}
	
	public DTSDataBuilder processKey(String val){
		this.processKey = val;
		return this;
	}
	
	public String getProcessKey() {
		return this.processKey;
	}
	
	public DTSDataBuilder startInstance(boolean val){
		this.startInstance = val;
		return this;
	}
	
	public boolean getStartInstance() {
		return this.startInstance;
	}
	
	public DTSData build(){
		return new DTSData(this);
	}
}