package com.bokesoft.yes.describe;

import java.util.HashMap;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class DescribeBuilder {

	private static final String TABLES = "formTable";
	
	private static final String DB_TABLES = "formDbTable";

	private static final String FORM_KEY = "formKey";
	
	private static final String FORM_TYPE = "formType";
	
	private static final String DATAOBJECT_KEY = "dataObjectKey";
	
	private static final String COLUMN_DB = "dbColumnName";
	
	private static final String COLUMN_TYPE = "dataType";
	
	private static final String COLUMN_CAPTION = "caption";
	
	private static final String COLUMN_KEY = "key";
	
	private static final String COLUMN_ITEMKEY = "itemKey";
	
	private static final String COLUMN_DICTABLE = "dicTable";
	
	private DefaultContext context = null;
	
	Map<String, Map<String, String>> dictMap = null;
	
	public DescribeBuilder(DefaultContext context){
		this.context = context;
	}
	
	
	/**
	 * 获取数据对象的配置描述
	 * @param metaForm
	 * @return
	 * @throws Throwable
	 */
	public JSONObject getDescribe(MetaForm metaForm) throws Throwable{
		buildDictMap(metaForm);
		MetaDataObject meta = metaForm.getDataSource().getDataObject();
		JSONObject result = new JSONObject();
		StringBuffer tables = new StringBuffer();
		StringBuffer dbTables = new StringBuffer();
		boolean firstTable = true;
		for(MetaTable metaTable: meta.getTableCollection()){
			String tableKey = metaTable.getKey();
			String db = metaTable.getDBTableName();
			if( db==null || db.isEmpty() )
				db = tableKey;
			if(firstTable == true){
				firstTable = false;
				tables.append(tableKey);
				dbTables.append(db);
			}
			else{
				tables.append(",").append(tableKey);
				dbTables.append(",").append(db);
			}
			JSONArray tableResult = getTableDescribe(metaTable);
			result.put(tableKey, tableResult);
		}
		result.put(TABLES, tables.toString());
		result.put(DB_TABLES, dbTables.toString());
		result.put(FORM_KEY, metaForm.getKey());
		result.put(DATAOBJECT_KEY, metaForm.getDataSource().getDataObject().getKey());
		result.put(FORM_TYPE, FormType.toString( metaForm.getFormType() ) );
		return result;
	}
	
	
	/**输出表的配置描述
	 * @param metaTable
	 * @return
	 * @throws Throwable
	 */
	private JSONArray getTableDescribe(MetaTable metaTable) throws Throwable{
		JSONArray result = new JSONArray();
		for(MetaColumn metaColumn: metaTable){
			JSONObject columnResult = getColumnDescribe(metaColumn, dictMap.get(metaTable.getKey()));
			result.put(columnResult);
		}
		return result;
	}
	
	/**
	 * 输出列的配置描述
	 * @param metaColumn
	 * @param tableMap
	 * @return
	 * @throws Throwable
	 */
	private JSONObject getColumnDescribe(MetaColumn metaColumn, Map<String, String> tableMap) throws Throwable
	{
		JSONObject result = new JSONObject();
		String dbColumnName = metaColumn.getDBColumnName();
		if(dbColumnName == null || dbColumnName.isEmpty() == true)
			result.put(COLUMN_DB, metaColumn.getKey());
		else
			result.put(COLUMN_DB, metaColumn.getDBColumnName());
		result.put(COLUMN_TYPE, DataType.toString( metaColumn.getDataType() ) );
		result.put(COLUMN_CAPTION, metaColumn.getCaption());
		result.put(COLUMN_KEY, metaColumn.getKey());
		if(tableMap != null){
			String itemKey = tableMap.get(metaColumn.getKey());
			if( itemKey!= null)
				result.put(COLUMN_ITEMKEY,itemKey);
				String dicTable = getDictTable(itemKey);
				if(dicTable != null)
					result.put(COLUMN_DICTABLE, dicTable);
		}	
		return result;
	}
	
	/**
	 * 遍历MetaForm，存储字典信息到Map。输出配置描述的时候根据Map来判断。
	 * @param metaForm
	 */
	private void buildDictMap(MetaForm metaForm){
		dictMap = new HashMap<String, Map<String, String>>();
		
		/*遍历所有component*/
		for(MetaComponent component: metaForm.getAllComponents()){
			/*处理Grid*/
			if(component instanceof MetaGrid){
				/*GridRow*/
				for(MetaGridRow gridRow:((MetaGrid)component).getRowCollection()){
					/*GridCell*/
					for(MetaGridCell gridCell: gridRow){
						int type = gridCell.getCellType();
						if(type == ControlType.DICT){
							/*DataBinding的columnKey*/
							String columnKey = gridCell.getDataBinding().getColumnKey();
							/*properties中去获取itemKey*/
							MetaDictProperties properties = (MetaDictProperties)gridCell.getProperties();
							String itemKey = properties.getItemKey();
							/*GridRow获取tableKey*/
							String tableKey = gridRow.getTableKey();
							Map<String,String> dictTable = dictMap.get(tableKey);
							if(dictTable == null)
							{
								dictTable = new HashMap<String,String>();
								dictMap.put(tableKey, dictTable);
							}
							dictTable.put(columnKey, itemKey);
						}
					}
				}
			}
		}
		
		/*查找另一种模式的字典*/
		for(MetaComponent component: metaForm.getAllComponents()){
			if(component instanceof MetaDict){
				MetaDict dict = (MetaDict) component;
				MetaDataBinding dataBinding = dict.getDataBinding();
				String tableKey = dataBinding.getTableKey();
				String columnKey = dataBinding.getColumnKey();
				String itemKey = dict.getItemKey();
				
				Map<String,String> dictTable = dictMap.get(tableKey);
				if(dictTable == null){
					dictTable = new HashMap<String,String>();
					dictMap.put(tableKey, dictTable);
				}
				dictTable.put(columnKey, itemKey);
			}
		}
	}
	
	/**
	 * 根据itemKey找到字典的数据库表名
	 * @param itemKey
	 * @return
	 * @throws Throwable
	 */
	private String getDictTable(String itemKey) throws Throwable{
		MetaDataObject meta = context.getVE().getMetaFactory().getDataObject(itemKey);
		if(meta == null)
			return null;
		return meta.getMainTable().getDBTableName();
	}
}
