package com.bokesoft.yes.data.cmd;

import java.util.List;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.cmd.util.CmdUtil;
import com.bokesoft.yes.struct.filedata.FileData;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.excel.IImportService2;
import com.bokesoft.yigo.meta.enhance.MetaDataProcess;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtDataProcess;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.MidCoreException;

public class ImportDataCmd extends DefaultServiceCmd {
	// 表单标识
	private String formKey = null;
	// 文件路径,以后可能支持多个文件同时导入
	private FileData fileData = null;
	// 自定义二开到导入服务名
	private String importServiceName = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		List<FileData> list = (List<FileData>)arguments.get("fileDatas");
		fileData = list != null && list.size() > 0 ? list.get(0) : null;
		importServiceName = TypeConvertor.toString(arguments.get("importServiceName"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		
		if(fileData == null){
			return null;
		}
		context.setFormKey(formKey);
		
		Object importService = null;
		// 判断是否调用自定义导入
		if( importServiceName != null && !importServiceName.isEmpty() ) {
			MetaEnhance enhance = context.getVE().getMetaFactory().getEnhance(null);
			if( enhance != null ) {
				MetaDataProcess dataProcess = null;
				MetaExtDataProcess extDataProcess = enhance.getMetaExtDataProcess();
				if ( extDataProcess != null ) {
					dataProcess = extDataProcess.get(importServiceName);
				}	
				if (dataProcess == null) {
					throw new MidCoreException(MidCoreException.UNIMPLEMENTED_SERVICE, importServiceName +MidCoreException.formatMessage(null, MidCoreException.UNIMPLEMENTED_SERVICE));
				}
				String impl = dataProcess.getImpl();
				if( impl != null && !impl.isEmpty() ) {
					importService = ReflectHelper.newInstance(context.getVE(), impl);					
				}
			}			
		}
		
		return importData(context, importService);
	}
	
	private Object importData(DefaultContext context, Object importService) throws Throwable{
		Object o = null;
		if(importService instanceof IImportService2){
			((IImportService2)importService).setFormKey(formKey);
			o = ((IImportService2)importService).importData(context, fileData.getData());
		}
		return o;
	}
	
	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ImportDataCmd();
	}

	@Override
	public String getCmd() {
		return null;
	}
	
	public void setImportServiceName(String importServiceName) {
		this.importServiceName = importServiceName;
	}
	
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	public void setFileData(FileData fileData) {
		this.fileData = fileData;
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
