package com.bokesoft.yes.csv.cmd.normal;

import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.struct.condition.ConditionParas;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.document.FilterMap;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class ExportCSVCmd extends DefaultServiceCmd {

	private String formKey = null;
	private Document document = null;
	private FilterMap filterMap = null;
	private ConditionParas condParameters = null;
	private String exportTables = null;
	private boolean onlyCurrentPage = false;
	private String postExportServiceName = null;
	private String exportFileName=null;
	private boolean needDownload = false;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		String parameters = arguments.get("parameters").toString();
		if (parameters != null && !parameters.isEmpty()) {
			JSONObject json = new JSONObject(parameters);
			Paras formParameters = new Paras();
			formParameters.fromJSON(json);
			context.setParas(formParameters);
		}
		
		formKey = arguments.get("formKey").toString();
		exportTables = arguments.get("exportTables").toString();
		onlyCurrentPage = TypeConvertor.toBoolean(arguments.get("onlyCurrentPage"));
		needDownload = TypeConvertor.toBoolean(arguments.get("needDownload"));
		postExportServiceName = arguments.get("postExportServiceName").toString();
		exportFileName=arguments.get("exportFileName").toString();
		
		JSONObject documentObj = new JSONObject(arguments.get("document").toString());
		long oid = TypeConvertor.toLong(arguments.get("OID"));
		
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		MetaDataObject metaDataObject = metaForm.getDataSource().getDataObject();
		
		filterMap = new FilterMap();
		filterMap.setOID(oid);
		String filterMapJSONStr = arguments.get("filterMap").toString();
		filterMap.fromJSON(new JSONObject(filterMapJSONStr));
		
		// 处理查询条件
		String conditions = arguments.get("condition").toString();
		if ( conditions != null && !conditions.isEmpty() ) {
			condParameters = new ConditionParas();
			condParameters.fromJSON(new JSONObject(conditions));
		}
		
		document = new Document(metaDataObject, oid);
		document.fromJSON(documentObj);
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		
		ExportCSV export = new ExportCSV(context, document, filterMap, condParameters, metaForm, exportTables, onlyCurrentPage, postExportServiceName,exportFileName,needDownload);
		return export.export();
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new ExportCSVCmd();
	}

	@Override
	public String getCmd() {
		return "ExportCSV";
	}
	
	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
