/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.panel;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSize;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaSplitLayout;
import java.util.LinkedList;

public class MetaSplitPanel
extends MetaPanel {
    public static final String TAG_NAME = "SplitPanel";
    private Integer orientation = 0;
    private MetaSplitSizeCollection splitSizeArray = new MetaSplitSizeCollection();

    public void setOrientation(Integer orientation) {
        this.orientation = orientation;
    }

    public Integer getOrientation() {
        return this.orientation;
    }

    public void setSplitSize(MetaSplitSizeCollection splitSizeArray) {
        this.splitSizeArray = splitSizeArray;
    }

    public MetaSplitSizeCollection getSplitSize() {
        return this.splitSizeArray;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public int getControlType() {
        return 3;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        for (MetaSplitSize size : this.splitSizeArray) {
            list.add(size);
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if ("SplitSize".equals(tagName)) {
            resultMetaObject = new MetaSplitSize();
            this.splitSizeArray.add(resultMetaObject);
        }
        if (resultMetaObject == null) {
            resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaSplitPanel newObject = (MetaSplitPanel)super.clone();
        newObject.setOrientation(this.orientation);
        MetaSplitSize size2 = null;
        MetaSplitSizeCollection newSplitSizeArray = new MetaSplitSizeCollection();
        for (MetaSplitSize size2 : this.splitSizeArray) {
            MetaSplitSize newSize = (MetaSplitSize)size2.clone();
            newSplitSizeArray.add(newSize);
        }
        newObject.setSplitSize(newSplitSizeArray);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaSplitPanel();
    }

    public MetaSplitLayout newLayout() {
        MetaSplitLayout layout = new MetaSplitLayout();
        layout.setOrientation(this.orientation);
        int size = this.componentArray.size();
        for (int i = 0; i < size; ++i) {
            MetaComponent metaComponent = (MetaComponent)this.componentArray.get(i);
            MetaLayoutSplitItem item = new MetaLayoutSplitItem();
            item.setKey(metaComponent.getKey());
            if (i < this.splitSizeArray.size() && i < size) {
                item.setSize(((MetaSplitSize)this.splitSizeArray.get(i)).getSize());
                item.setType(((MetaSplitSize)this.splitSizeArray.get(i)).getType());
                item.setForwardCollapased(((MetaSplitSize)this.splitSizeArray.get(i)).getForwardCollapased());
                item.setReverseCollapased(((MetaSplitSize)this.splitSizeArray.get(i)).getReverseCollapased());
            }
            layout.add((KeyPairMetaObject)item);
        }
        return layout;
    }

    @Override
    public AbstractMetaObject getProperties() {
        return null;
    }

    @Override
    public void merge(MetaComponent meta) {
        super.merge(meta);
        MetaSplitPanel metaPanel = (MetaSplitPanel)meta;
        if (this.orientation == -1) {
            this.orientation = metaPanel.getOrientation();
        }
        MetaSplitSizeCollection splitSizeArray2 = metaPanel.getSplitSize();
        if (this.splitSizeArray == null) {
            this.splitSizeArray = splitSizeArray2;
        } else {
            int i;
            int size = this.splitSizeArray.size();
            int size2 = splitSizeArray2.size();
            int maxSize = Math.max(size, size2);
            for (i = size; i < maxSize; ++i) {
                this.splitSizeArray.add(splitSizeArray2.get(i));
            }
            for (i = size2; i < maxSize; ++i) {
                splitSizeArray2.add(this.splitSizeArray.get(i));
            }
        }
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        for (int i = 0; i < this.componentArray.size(); ++i) {
            try {
                MetaSplitSize metaSplitSize = (MetaSplitSize)this.splitSizeArray.get(i);
                if (metaSplitSize != null && metaSplitSize.getSize() != null) continue;
                throw new MetaException(125, SimpleStringFormat.format((String)StringTable.getString(null, "", "NoDefinitionOfSize"), (Object[])new Object[]{this.getKey(), ((MetaComponent)this.componentArray.get(i)).getKey()}));
            }
            catch (IndexOutOfBoundsException e) {
                throw new MetaException(125, SimpleStringFormat.format((String)StringTable.getString(null, "", "NoDefinitionOfSize"), (Object[])new Object[]{this.getKey(), ((MetaComponent)this.componentArray.get(i)).getKey()}));
            }
        }
    }
}

