/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.flatcanvas.node;

import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.node.AbstractMetaFCObject;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCBoard;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;

public class MetaFCPaper
extends AbstractMetaFCObject {
    public static final String TAG_NAME = "Paper";
    public static final List<String> ATTRS_PAPER = Arrays.asList("key", "caption");
    private MetaFCBoard board = new MetaFCBoard();
    private MetaFCDataSource dataSource = new MetaFCDataSource();

    public MetaFCPaper() {
        this.dataSource.setRefObjectKey("");
    }

    public MetaFCBoard getMetaBoard() {
        return this.board;
    }

    public MetaFCDataSource getDataSource() {
        return this.dataSource;
    }

    public Integer getWidth() {
        return this.board.getWidth();
    }

    public void setWidth(int width) {
        this.board.setWidth(width);
    }

    public Integer getHeight() {
        return this.board.getHeight();
    }

    public void setHeight(int height) {
        this.board.setHeight(height);
    }

    @Override
    public List<String> getPropItemKeys() {
        return ATTRS_PAPER;
    }

    @Override
    public List<AttributeItem> getPropItems() {
        ArrayList<AttributeItem> items = new ArrayList<AttributeItem>();
        List<AttributeItem> propItems = super.getPropItems();
        for (AttributeItem item : propItems) {
            items.add(item);
        }
        propItems = this.board.getPropItems();
        for (AttributeItem item : propItems) {
            items.add(item);
        }
        propItems = this.dataSource.getPropItems();
        for (AttributeItem item : propItems) {
            items.add(item);
        }
        return items;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void loadChild(Element elem) {
        Element child = (Element)elem.getElementsByTagName("Board").item(0);
        this.board.loadFromElement(child);
        child = (Element)elem.getElementsByTagName("DataSource").item(0);
        this.dataSource.loadFromElement(child);
    }

    @Override
    protected boolean isCollection() {
        return false;
    }

    @Override
    protected boolean saveChild(IContentHandler saveHandler, INode node) {
        boolean result = this.board.saveTo(saveHandler, node);
        return result |= this.dataSource.saveTo(saveHandler, node);
    }
}

