/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.flatcanvas.node;

import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.flatcanvas.common.AttributeItem;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;
import com.bokesoft.yigo.meta.flatcanvas.node.AbstractMetaFCNode;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCText;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCTextCollection;
import com.bokesoft.yigo.meta.flatcanvas.util.FCUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaFCGraph
extends AbstractMetaFCNode {
    public static final String TAG_NAME = "Graph";
    private static final List<String> ATTRS_COMMON = Arrays.asList("type", "fill", "stroke", "strokewidth", "strokeopacity", "ondblclick", "showcaption", "statusfill");
    private static HashMap<String, List<String>> ATTRS_GRAPH_MAP = new HashMap();
    private MetaFCTextCollection textCollection = new MetaFCTextCollection();

    public String getPoints() {
        return this.get("points");
    }

    public void setPoints(String points) {
        this.set("points", points);
    }

    public void setFrom(String start) {
        this.set("from", start);
    }

    public String getFrom() {
        return this.get("from");
    }

    public void setTo(String end) {
        this.set("to", end);
    }

    public String getTo() {
        return this.get("to");
    }

    public Integer getR() {
        return TypeConvertor.toInteger((Object)this.get("r"));
    }

    public void setR(int r) {
        this.set("r", r);
    }

    public Integer getWidth() {
        return TypeConvertor.toInteger((Object)this.get("width"));
    }

    public void setWidth(int width) {
        this.set("width", width);
    }

    public Integer getHeight() {
        return TypeConvertor.toInteger((Object)this.get("height"));
    }

    public void setHeight(int height) {
        this.set("height", height);
    }

    @Override
    public String getType() {
        return this.get("type");
    }

    @Override
    public void setType(String type) {
        this.set("type", type);
    }

    public String getText() {
        return this.get("text");
    }

    public void setText(String text) {
        this.set("text", text);
    }

    public void setStroke(double red, double green, double blue) {
        this.set("stroke", FCUtil.colorValueToHex(red, green, blue));
    }

    public Object getStroke() {
        return this.get("stroke");
    }

    public void setStrokeWidth(double width) {
        this.set("strokewidth", width);
    }

    public double getStrokeWidth() {
        return TypeConvertor.toDouble((Object)this.get("strokewidth"));
    }

    public double getStrokeOpacity() {
        return TypeConvertor.toDouble((Object)this.get("strokeopacity"));
    }

    public void setStrokeOpacity(double opacity) {
        this.set("strokeopacity", opacity);
    }

    public void setFill(double red, double green, double blue) {
        this.set("fill", FCUtil.colorValueToHex(red, green, blue));
    }

    public Object getFill() {
        return this.get("fill");
    }

    public String getStatusFill() {
        return this.get("statusfill");
    }

    public void setOnDblClick(String sFormula) {
        this.set("ondblclick", sFormula);
    }

    public String getOnDblClick() {
        return this.get("ondblclick");
    }

    @Override
    public List<String> getPropItemKeys() {
        String type = this.getType();
        List<String> listGraphAttr = ATTRS_GRAPH_MAP.get(type);
        if (listGraphAttr == null) {
            listGraphAttr = new ArrayList<String>();
        }
        List<String> list = FCUtil.concatList(listGraphAttr, ATTRS_COMMON);
        return list;
    }

    @Override
    public List<AttributeItem> getPropItems() {
        ArrayList<AttributeItem> items = new ArrayList<AttributeItem>();
        List<String> list = this.getPropItemKeys();
        for (String attrName : list) {
            AttributeItem item = this.getAttrItem(attrName);
            if (item == null) {
                this.set(attrName, "");
            }
            items.add(this.getAttrItem(attrName));
        }
        return items;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void loadChild(Element elem) {
        NodeList childNodes = elem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element element;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !"TextCollection".equalsIgnoreCase((element = (Element)node).getTagName())) continue;
            this.textCollection.loadFromElement(element);
        }
    }

    @Override
    protected boolean isCollection() {
        return false;
    }

    @Override
    protected boolean saveChild(IContentHandler saveHandler, INode node) {
        return this.textCollection.saveTo(saveHandler, node);
    }

    public Collection<MetaFCText> texts() {
        return this.textCollection.values();
    }

    public void addText(MetaFCText text) {
        this.textCollection.addItem(text);
    }

    public void removeText(MetaFCText text) {
        this.textCollection.remove(text);
    }

    static {
        ATTRS_GRAPH_MAP.put("rect", Arrays.asList("x", "y", "width", "height"));
        ATTRS_GRAPH_MAP.put("circle", Arrays.asList("x", "y", "r"));
        ATTRS_GRAPH_MAP.put("text", Arrays.asList("x", "y", "text"));
        ATTRS_GRAPH_MAP.put("polygon", Arrays.asList("points"));
        ATTRS_GRAPH_MAP.put("polyline", Arrays.asList("from", "to", "points"));
    }
}

