/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.node;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TagNode
extends AbstractNode {
    private String tagName = null;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private List<AbstractNode> nodes = new ArrayList<AbstractNode>();

    public TagNode() {
        super("");
    }

    public TagNode(String tagName) {
        super("");
        this.tagName = tagName;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        if (attributes != null) {
            this.attributes = attributes;
        }
    }

    public boolean hasAttribute(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    public List<AbstractNode> getChildren() {
        return this.nodes;
    }

    public List<AbstractNode> getChildrenByTagName(String name) {
        ArrayList<AbstractNode> list = new ArrayList<AbstractNode>();
        List<AbstractNode> ch = this.getChildren();
        for (int i = 0; i < ch.size(); ++i) {
            if (ch.get(i) instanceof TagNode || !((TagNode)ch.get(i)).getTagName().equals(name)) continue;
            list.add((TagNode)ch.get(i));
        }
        return list;
    }

    public TagNode findChildByTagNode(TagNode tagNode) {
        for (AbstractNode ch : this.nodes) {
            String findPrimaryKey;
            String curPrimaryKey;
            if (!(ch instanceof TagNode) || !(curPrimaryKey = ((TagNode)ch).getPrimaryKey()).equalsIgnoreCase(findPrimaryKey = tagNode.getPrimaryKey())) continue;
            return (TagNode)ch;
        }
        return null;
    }

    public TagNode findFirstTagNodeByTagName(String tagName) {
        List<TagNode> list = this.findNodesByTagName(tagName);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<TagNode> findNodesByTagName(String tagName) {
        if (tagName == null) {
            return null;
        }
        ArrayList<TagNode> list = new ArrayList<TagNode>();
        this.loadNodesByTagName(tagName, list);
        return list;
    }

    public void loadNodesByTagName(String tagName, List<TagNode> list) {
        if (tagName == null) {
            return;
        }
        if (tagName.equals(this.getTagName())) {
            list.add(this);
            return;
        }
        for (AbstractNode ch : this.nodes) {
            if (!(ch instanceof TagNode)) continue;
            ((TagNode)ch).loadNodesByTagName(tagName, list);
        }
    }

    public TagNode getFirst(String tag) {
        List<AbstractNode> tem = this.getChildrenByTagName(tag);
        if (tem.size() == 0) {
            return null;
        }
        return (TagNode)tem.get(0);
    }

    public TagNode getLast(String tag) {
        List<AbstractNode> tem = this.getChildrenByTagName(tag);
        if (tem.size() == 0) {
            return null;
        }
        return (TagNode)tem.get(tem.size() - 1);
    }

    public AbstractNode getFirst() {
        List<AbstractNode> list = this.getChildren();
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public AbstractNode getLast() {
        List<AbstractNode> list = this.getChildren();
        if (list.size() == 0) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public TagNode addNode(AbstractNode node) {
        if (node == null) {
            throw new IllegalArgumentException("addNode:node cant null");
        }
        this.nodes.add(node);
        node.setParent(this);
        return this;
    }

    public TagNode setAttribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public String getTagName() {
        return this.tagName;
    }

    public TagNode setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    public String getPrimaryKey() {
        if (this.tagName == null) {
            return null;
        }
        String attrKey = DefaultNodeDefine.getInstance().getPrimaryKey(this.tagName);
        String primaryValue = this.attributes.get(attrKey);
        primaryValue = primaryValue == null ? "" : primaryValue;
        return this.tagName.concat("@").concat(primaryValue);
    }

    @Override
    public String toXml(int level) {
        StringBuilder strBuilder = new StringBuilder();
        if (level == 0) {
            strBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n");
            this.appendPreComment(strBuilder, this, level);
        }
        this.appendLevelBlank(strBuilder, level);
        String sAttrs = this.getAttrsString();
        strBuilder.append("<").append(this.tagName);
        if (!StringUtil.isEmptyStr((String)sAttrs)) {
            strBuilder.append(" ");
        }
        strBuilder.append(sAttrs);
        if (this.nodes.size() > 0) {
            strBuilder.append(">").append("\r\n");
            for (AbstractNode node : this.nodes) {
                this.appendPreComment(strBuilder, node, level + 1);
                strBuilder.append(node.toXml(level + 1)).append("\r\n");
                this.appendLastComment(strBuilder, node, level + 1);
            }
            this.appendLevelBlank(strBuilder, level);
            strBuilder.append("</").append(this.tagName).append(">");
        } else {
            strBuilder.append("/>");
        }
        if (level == 0) {
            strBuilder.append("\r\n");
            this.appendLastComment(strBuilder, this, level);
        }
        return strBuilder.toString();
    }

    private void appendPreComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List<AbstractNode> listPreComment = node.getPreComment();
        if (listPreComment == null) {
            return;
        }
        for (AbstractNode comment : listPreComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }

    private void appendLastComment(StringBuilder strBuilder, AbstractNode node, int level) {
        List<AbstractNode> listLastComment = node.getLastComment();
        if (listLastComment == null) {
            return;
        }
        for (AbstractNode comment : listLastComment) {
            strBuilder.append(comment.toXml(level)).append("\r\n");
        }
    }

    private String getAttrsString() {
        String sAttrs = "";
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (sAttrs.length() == 0) {
                sAttrs = entry.getKey() + "=\"" + this.convertSpecialChars(entry.getValue()) + "\"";
                continue;
            }
            sAttrs = sAttrs + " " + entry.getKey() + "=\"" + this.convertSpecialChars(entry.getValue()) + "\"";
        }
        return sAttrs;
    }

    @Override
    public AbstractNode clone() {
        TagNode node = new TagNode(this.getTagName());
        for (Map.Entry<String, String> entry : this.getAttributes().entrySet()) {
            node.setAttribute(entry.getKey(), entry.getValue());
        }
        for (AbstractNode tmpNode : this.nodes) {
            node.getChildren().add(tmpNode.clone());
        }
        return node;
    }

    @Override
    public boolean hasPrimaryAttribute() {
        String primaryAttrKey = DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
        return !StringUtil.isBlankOrNull((String)this.attributes.get(primaryAttrKey));
    }

    public String getPrimaryAttrName() {
        return DefaultNodeDefine.getInstance().getPrimaryKey(this.getTagName());
    }
}

