/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom;

import com.bokesoft.yes.meta.persist.dom.dataobject.MetaCheckRuleAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaActionMap;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRule;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRuleCollection;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractLoad
implements IMetaEnv {
    protected IMetaActionMap actionMap = null;
    protected IMetaActionMap extActionMap = null;
    protected AbstractMetaObject rootMetaObject = null;
    protected int runType = 1;
    protected String resource = null;

    public AbstractLoad(int runType) {
        this.runType = runType;
        this.actionMap = this.getActionMap();
        this.extActionMap = this.getExtendActionMap();
    }

    public void load(IMetaResolver resolver, String resource) throws Exception {
        this.resource = resource;
        try (InputStream in = resolver.read(resource, -1);){
            if (in == null) {
                this.rootMetaObject = null;
            } else {
                Document document = DomHelper.createDocument((InputStream)in);
                this.load(document);
            }
        }
    }

    public void load(InputStream in) throws Throwable {
        Document document = DomHelper.createDocument((InputStream)in);
        this.load(document);
    }

    public void load(Document document) throws MetaException {
        Element rootElement = document.getDocumentElement();
        this.rootMetaObject = this.newRootMetaObject(rootElement);
        if (this.rootMetaObject.needPreLoad()) {
            this.rootMetaObject.preProcessMetaObject(this, document, rootElement, false, this.runType);
        }
        this.processActionMap(rootElement);
        this.loadMetaObject(document, null, rootElement, this.rootMetaObject);
    }

    @Override
    public boolean checkExtend(AbstractMetaObject meta, Object node) {
        return false;
    }

    private void loadMetaObject(Document document, AbstractMetaObject parent, Element element, AbstractMetaObject meta) throws MetaException {
        if (parent instanceof MetaCheckRuleCollection && meta instanceof MetaCheckRule) {
            MetaCheckRuleAction action = new MetaCheckRuleAction();
            if (!meta.needPreLoad()) {
                action.process(this, document, element, (MetaCheckRule)meta, false, this.runType);
            }
        } else {
            String tagName = element.getTagName();
            IMetaAction<AbstractMetaObject> action = this.getAction(meta, element);
            if (action == null && parent != null) {
                action = this.getAction(parent.getTagName(), tagName);
            }
            if (action == null) {
                throw new MetaException(1, "No action defined for " + tagName);
            }
            if (!meta.needPreLoad()) {
                action.process(this, document, element, meta, false, this.runType);
            }
        }
        List childNodeList = DomHelper.getChildList((Element)element);
        Element childElement2 = null;
        for (Element childElement2 : childNodeList) {
            AbstractMetaObject childMetaObject = meta.createChildMetaObject(this, document, childElement2, childElement2.getTagName(), false, this.runType);
            if (childMetaObject == null) {
                throw new MetaException(12, "file " + this.resource + " " + element.getTagName() + " no creator defined for child element " + childElement2.getTagName());
            }
            this.loadMetaObject(document, meta, childElement2, childMetaObject);
        }
    }

    public AbstractMetaObject getRootMetaObject() {
        return this.rootMetaObject;
    }

    protected abstract AbstractMetaObject newRootMetaObject(Element var1);

    protected void processActionMap(Element root) {
    }

    protected abstract IMetaActionMap getActionMap();

    protected IMetaActionMap getExtendActionMap() {
        return null;
    }

    @Override
    public Object prepare(AbstractMetaObject meta, Object node) {
        return null;
    }

    @Override
    public IMetaAction<AbstractMetaObject> getAction(AbstractMetaObject meta, Object node) {
        IMetaAction<AbstractMetaObject> action = null;
        String tagName = meta.getTagName();
        if (this.extActionMap != null && this.checkExtend(meta, node)) {
            action = this.extActionMap.getAction(tagName);
        }
        if (action == null) {
            action = this.actionMap.getAction(tagName);
        }
        return action;
    }

    private IMetaAction<AbstractMetaObject> getAction(String parentTagName, String tagName) {
        return this.actionMap.getAction(parentTagName, tagName);
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }
}

