package com.bokesoft.yigo.meta.util;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

/**
 * MetaColumn工具类用于自动创建列
 */
public class MetaColumnUtil {
	
	/**
	 * 创建metaColumn
	 * @param key 标识
	 * @param caption 名称
 	 * @param dataElement 数据元素
	 * @return metaColumn
	 */
	public static MetaColumn createMetaColumn(String key, String caption, MetaDataElement dataElement) {
		MetaColumn meta = new MetaColumn();
		meta.setKey(key);
		meta.setCaption(caption);
		return mergeMetaColumn(meta, dataElement);
	}

	/**
	 * 创建metaColumn，Key、Caption属性和数据元素保持一致
	 * 
	 * @param dataElement
	 * @return
	 */
	public static MetaColumn createMetaColumn(MetaDataElement dataElement) {
		return createMetaColumn(dataElement.getKey(), dataElement.getCaption(), dataElement);
	}
	
	/**
	 * 合并metaColumn
	 * @param meta 列
	 * @param dataElement 数据元素
	 * @return 列
	 */
	public static MetaColumn mergeMetaColumn(MetaColumn meta, MetaDataElement dataElement) {
		if(dataElement != null) {
			meta.setDataElementKey(dataElement.getKey());
			meta.setDataElement(dataElement);
			MetaAnnotationUtil.mergeProperty(meta, dataElement);
		}
		return meta;
	}
	
	/**
	 * 合并metaColumn
	 * @param metaFactory 配置工厂
	 * @param meta 列
	 * @param dataElementKey 数据元素
	 * @return 列
	 */
	public static MetaColumn mergeMetaColumn(IMetaFactory metaFactory, MetaColumn meta, String dataElementKey) {
		// 获取主solution的DataElement集合
		MetaDataElement dataElement = metaFactory.getDataElementDef("").getDataElement(dataElementKey);
    	if(dataElement == null) {
    		throw new MetaException(MetaException.NO_DATAELEMENT_DEFINED, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataElementDefined), dataElementKey));
    	}
		return mergeMetaColumn(meta, dataElement);
	}
}
