package com.bokesoft.yigo.meta.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.yigo.common.def.OverwriteType;
import com.bokesoft.yigo.meta.annotation.DataElementAttribute;
import com.bokesoft.yigo.meta.annotation.DomainAttribute;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.domain.MetaDomain;

public class MetaAnnotationUtil {
	
	private static Map<String, List<Field>> fieldCache = new HashMap<String, List<Field>>();
	/**
	 * 合并域对象属性
	 * @param instance 实例
	 * @param ref 域对象
	 */
	public static void mergeProperty(Object instance, MetaDomain ref) {
		Class<?> clazz = instance.getClass();
		String key = clazz.getName() + "_MetaDomain";
		List<Field> list = fieldCache.get(key);
		if(list == null) {
			list = new ArrayList<Field>();
			while(clazz != null) {
				Field[] fields = clazz.getDeclaredFields();
				for(Field field: fields) {
					DomainAttribute annotation = field.getAnnotation(DomainAttribute.class);
					if(annotation != null) {
						list.add(field);
					}
				}
				// 获取父类
				clazz = clazz.getSuperclass();
			}
			fieldCache.put(key, list);
		}
		clazz = instance.getClass();
		for(Field field : list) {
			DomainAttribute annotation = field.getAnnotation(DomainAttribute.class);
			doMerge(clazz, instance, ref, field.getName(), annotation.refName(), annotation.allowNull());
		}
		
	}

	/**
	 * 合并数据元素属性
	 * @param instance 实例
	 * @param ref 数据元素对象
	 */
	public static void mergeProperty(Object instance, MetaDataElement ref) {
		Class<?> clazz = instance.getClass();
		String key = clazz.getName() + "_MetaDataElement";
		List<Field> list = fieldCache.get(key);
		if(list == null) {
			list = new ArrayList<Field>();
			while(clazz != null) {
				Field[] fields = clazz.getDeclaredFields();
				for(Field field: fields) {
					DataElementAttribute annotation = field.getAnnotation(DataElementAttribute.class);
					if(annotation != null) {
						list.add(field);
					} 
				}
				// 获取父类
				clazz = clazz.getSuperclass();
			}
			fieldCache.put(key, list);
		}
		
		clazz = instance.getClass();
		for(Field field : list) {
			DataElementAttribute annotation = field.getAnnotation(DataElementAttribute.class);
			int overwriteType = annotation.overwriteType();
			if(overwriteType == OverwriteType.IF_EMPTY) {
				Object old = null;
				try {
					old = getFieldValue(field.getName(), clazz, instance);
				} catch (Throwable e) {
					throw new RuntimeException(e);
				}
				if(old == null || "".equals(old)) {
					doMerge(clazz, instance, ref, field.getName(), annotation.refName(), annotation.allowNull());
				}
			}else if(overwriteType == OverwriteType.MERGE){
				throw new RuntimeException("mergeProperty merge not impl");
			}else {
				doMerge(clazz, instance, ref, field.getName(), annotation.refName(), annotation.allowNull());
			}
		}
	}
	
	private static void doMerge(Class<?> instanceClazz, Object instance, Object ref, String srcFieldName, String refFieldName, boolean allowNull) {
		Object v = null;	
		try {
			if(refFieldName == null || refFieldName.isEmpty()) {
				refFieldName = srcFieldName;
			}
			v = getFieldValue(refFieldName, ref.getClass(), ref);
			// 不允许为null 且值为null时什么都不做
			if(!allowNull && v==null) {
				
			}else{
				setFieldValue(instanceClazz, instance, srcFieldName, v);
			}
		} catch (Throwable  e) {
			throw new RuntimeException(e);
		}
	}
	
	private static Object getFieldValue(String fieldName, Class<?> clazz, Object ref) throws Throwable{
		Method getMethod = getReadMethod(fieldName, clazz);
		Object v = null;
		if(getMethod != null) {
			v = getMethod.invoke(ref);
		}else {
			throw new RuntimeException("Field:" + fieldName + " getValue is error");
		}
			
		return v;
	}
	
	private static Map<String, Method> methodCache = new HashMap<String, Method>();
	private static Method getReadMethod(String fieldName, Class<?> clazz) throws Throwable{
		String key = clazz.getName() + "_rm_" + fieldName;
		Method m = methodCache.get(key);
		if(m == null) {
			PropertyDescriptor pd = new PropertyDescriptor(fieldName, clazz);
			m = pd.getReadMethod();
			methodCache.put(key, m);
		}
		return m;
	}
	
	private static void setFieldValue(Class<?> instanceClazz, Object instance, String fieldName, Object v) throws Throwable{
		Method setMethod = getWriteMethod(fieldName, instanceClazz);
		if(setMethod != null) {
			setMethod.invoke(instance, v);
		}else {
			throw new RuntimeException("Field:" + fieldName + " setValue is error");
		}
	}
	
	private static Method getWriteMethod(String fieldName, Class<?> clazz) throws Throwable{
		
		String key = clazz.getName() + "_wm_" + fieldName;
		Method m = methodCache.get(key);
		if(m == null) {
			PropertyDescriptor pd = new PropertyDescriptor(fieldName, clazz);
			m = pd.getWriteMethod();
			methodCache.put(key, m);
		}
		return m;
	}
}
