package com.bokesoft.yigo.meta.timer.period;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class WorkDay extends Period {

	public static final String TAG_NAME = "WorkDay";

	private Integer dayCount = -1;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new WorkDay();
	}

	public Integer getDayCount() {
		return dayCount;
	}

	public void setDayCount(Integer dayCount) {
		this.dayCount = dayCount;
	}

	@Override
	public AbstractMetaObject clone() {
		WorkDay newWorkDay = (WorkDay) newInstance();
		newWorkDay.setDayCount(dayCount);
		return newWorkDay;
	}

}
